<?php

namespace App\Http\Controllers\admin\master;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Auth, Validator, Redirect;
use App\Models\Algo;
use App\Components\AlgoManager;
use Illuminate\Http\Request;
class AlgoController extends Controller
{
    public function __construct()
    {
    }
	
	public function index() 
	{
		return view('admin/algo/index');
    }
	
	public function save(Request $request)
	{
		try
		{
			if($request->isMethod('post'))
			{
				$params = $request->all();
				$messages = [
					'max' => 'Description should not be greater than 50 characters.',
				];
				$validator = Validator::make($params,[
					'name' =>'required',
                    'value'=>'required'
				], $messages);
				
				if($validator->fails())
				{
					return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
				}

                $departmentObj = AlgoManager::getInstance();
				
				$status = $departmentObj->create(['name' => $request->name,'value' => $request->value]);
				
				if($status)
				{
					return response()->json(array('status'=>'success'));
				}
				
				return response()->json(array('status'=>'error', 'error' => 'Something Wrong'));
			}
		
			return redirect('home')->with('error', 'Not valid');
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','error'=>$error));
		}
	}
	
	public function update(Request $request)
	{
		try
		{
			$params = $request->all();
			$messages = [
				'max' => 'Description should not be greater than 50 characters.',
			];
			$validator = Validator::make($params,[
				'name' =>'required',
                'value'=>'required'
			], $messages);
			
			if($validator->fails())
			{
				return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
			}

			$id = $request->id;
			
			$user_id=Auth::guard('admin')->user()->id;

			$oldstate = Algo::find($request->id);
			$clone = $oldstate->replicate();

			$params=[
				'name' => $request->name,
				'value' => $request->value,
			];

			$status = $oldstate->update($params);

			$newstate=$oldstate->getChanges();
			$changes = ' ID- '.$request->id.' ';

			foreach($params as $key=> $para){
				if(isset($newstate[$key]) && isset($clone->$key)){
					   $changes .= $key.' Old Value '.$clone->$key.' New Value '.$para.' ';
				}
			}

			$st=Storehistory($user_id,'Algo Master','Update',$changes);


			if($status)
			{
				return response()->json(array('status'=>'success', 'message' => 'Successfully Update.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','erorr'=>$error));
		}
	}
	
	public function deleteById(Request $request)
	{
		try
		{
			$id = $request->id;
			$departmentObj = AlgoManager::getInstance();
			$department = $departmentObj->getAlgoById($id);
			
			if($department == null)
			{
				return response()->json(array('status'=>'error', 'message' => 'Record not found.'));
			}
			
			$status = $departmentObj->deleteById($id);
			
			if($status)
			{
				$user_id=Auth::guard('admin')->user()->id;
				$st=Storehistory($user_id,'Algo Master','Delete',$department);
				return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError'));
		}
	}
	
	public function get(Request $request)
	{
		$id = $request->id;
		$departmentObj = AlgoManager::getInstance();
		$department = $departmentObj->getAlgoById($id);
		if($department == null)
		{
			return response()->json(array('status'=>'error', 'message' => 'Record not found.'));
		}
		
		return response()->json(array('status'=>'success', 'data' => $department));
		
	}
	
	public function ajaxcall(Request $request)
	{
		 ## Read value
		 $draw = $request->get('draw');
		 $start = $request->get("start");
		 $rowperpage = $request->get("length"); 

		 $columnIndex_arr = $request->get('order');
		 $columnName_arr = $request->get('columns');
		 $order_arr = $request->get('order');
		 $search_arr = $request->get('search');

		 $columnIndex = $columnIndex_arr[0]['column']; 
		 $columnName = $columnName_arr[$columnIndex]['data'];
		 $columnSortOrder = $order_arr[0]['dir']; 
		 $searchValue = $search_arr['value']; 

		 $countData = Algo::select('count(*) as allcount');

		if($searchValue != null) {
			$countData->where('name', 'like', '%' .$searchValue . '%');
		}

		
		$totalRecordswithFilter = $countData->count();
		$totalRecords = $totalRecordswithFilter;
		 $records = Algo::select('*')
		   ->skip($start)
		   ->take($rowperpage);
		   
			if($columnName == 'id') {
			   $records->orderBy($columnName,$columnSortOrder);
			}
			
			if($searchValue != null) {
				$records->where('name', 'like', '%' .$searchValue . '%');
			}

		
		$list = $records->get();

		 $data_arr = array();
		 
		 foreach($list as $sno => $record){
			$id = $record->id;
			$code = '<a href="javascript:void(0);" style="border-bottom:dashed 1px #0088cc" class="view" data-id="'.$id.'">'.$record->pincode.'</a>';
			$description = $record->name;
			$edit = asset('icon/edit2.png');
			$delete = asset('icon/del.png');

			$action='';

			$userid=Auth::guard('admin')->user()->id;

			$edit=$del=true;
			

			if($edit){
				$action.=' <a class="dropdown-items update" href="javascript:void(0);" style="float:left" data-id="'.$id.'" ><i class="fa fa-edit fs-4"></i></a>';
			}

			if($del){
				$action.= '<a class="dropdown-items delete" href="javascript:void(0);" style="margin-left:10px;float:left" data-id="'.$id.'"><i class="fa fa-trash fs-4"></i></a>';
			}

		
			$data_arr[] = array(
			  "id" => ++$start,
			  "name" => $record->name,
			  "value" => $record->value,
			  "Action" => $action
			);
		 }

		 $response = array(
			"draw" => intval($draw),
			"iTotalRecords" => $totalRecords,
			"iTotalDisplayRecords" => $totalRecordswithFilter,
			"aaData" => $data_arr
		 );

		 echo json_encode($response);
		 exit;
	}
	
	private function exceptionHandling($error)
	{
			$obj = \App\Components\AuditReportManager::getInstance();
			$data = array('name' => "Algo Master", 'data' => $error, 'user_id' => Auth::user()->id);
			$obj->save($data);		
	}
	
}