<?php

namespace App\Http\Controllers\admin\master;

use App\Http\Controllers\Controller;
use App\Imports\BardImport;
use App\Models\Bard;
use App\Models\State;
use App\Providers\RouteServiceProvider;
use Hash;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Auth, Validator, Redirect;
use App\Components\BardManager;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
class BardController extends Controller
{
	
	public function index() 
	{
		return view('admin/bards/index');
	}
	
	public function save(Request $request)
	{
        try
		{
			if($request->isMethod('post'))
			{
				$params = $request->all();
				$messages = [
					'max' => 'Board Name should not be greater than 50 characters.',
				];
				$validator = Validator::make($params,[
					'description' =>'required|unique:boards,description|regex:/^[a-zA-Z0-9& ]+$/',
					'max_affilation_no' =>'required|numeric',
				], $messages);
				
				if($validator->fails())
				{
					return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
				}
				$departmentObj = BardManager::getInstance();
				
                $params=[
                    'description' =>$request->description,
					'max_affilation_no' =>$request->max_affilation_no
                ];

				$status = $departmentObj->create($params);
				
				if($status)
				{
					return response()->json(array('status'=>'success'));
				}
				
				return response()->json(array('status'=>'error', 'error' => 'Something Wrong'));
			}
		
			return redirect('home')->with('error', 'Not valid');
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','error'=>$error));
		}

	}
	
	public function update(Request $request)
	{
        try
		{
			$params = $request->all();
				$messages = [
				];
				$validator = Validator::make($params,[
                    'description' =>'required|regex:/^[a-zA-Z0-9& ]+$/',
					'max_affilation_no' =>'required'
				], $messages);
				
				if($validator->fails())
				{
					return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
				}
				$departmentObj = BardManager::getInstance();
				
               
                $params=[
                    'description' =>$request->description,
					'max_affilation_no' =>$request->max_affilation_no,
					
                ];

			$status = $departmentObj->updateById($request->id, $params);
			
			if($status)
			{
				return response()->json(array('status'=>'success', 'message' => 'Successfully Update.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError'));
		}
	}
	
	public function deleteById(Request $request)
	{
		try
		{
			$id = $request->id;
			$departmentObj = BardManager::getInstance();
			$department = $departmentObj->getBardById($id);
			
			if($department == null)
			{
				return response()->json(array('status'=>'error', 'message' => 'Record not found.'));
			}
			
			$status = $departmentObj->deleteById($id);
			
			if($status)
			{
				return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','error'=>$error));
		}
	}
	
	public function get(Request $request)
	{
		
		$id = $request->id;
		$departmentObj = Bard::find($id);
		return response()->json(array('status'=>'success', 'data' =>$departmentObj ));
		
	}
	
	public function ajaxcall(Request $request)
	{
		 $draw = $request->get('draw');
		 $start = $request->get("start");
		 $rowperpage = $request->get("length");

		 $columnIndex_arr = $request->get('order');
		 $columnName_arr = $request->get('columns');
		 $order_arr = $request->get('order');
		 $search_arr = $request->get('search');

		 $columnIndex = $columnIndex_arr[0]['column'];
		 $columnName = $columnName_arr[$columnIndex]['data']; 
		 $columnSortOrder = $order_arr[0]['dir']; 
		 $searchValue = $search_arr['value']; 

		 $countData = Bard::select('count(*) as allcount');		 
         
        if($searchValue != null) {
		$countData->where('description', 'like', '%' .$searchValue . '%');		}
	
		$totalRecordswithFilter = $countData->count();

		$totalRecords = $totalRecordswithFilter;
		$records = Bard::select('*')
		   ->skip($start)
		   ->take($rowperpage)
		   ->orderBy('id','asc');

        if($searchValue != null) {
			$records->where('description', 'like', '%' .$searchValue . '%');
		}

		$list = $records->get();

		$data_arr = array();
		 
		 foreach($list as $sno => $record){

			$id = $record->id;
			$code = '<a href="javascript:void(0);" style="" class="view" data-id="'.$id.'">'.$record->username.'</a>';
			$edit = asset('icon/edit2.png');
			$delete = asset('icon/del.png');
            $action='';

			$action='';

			$userid=Auth::guard('admin')->user()->id;

			$edit=$del=true;
			$priv=getUserHasRoleProgram($userid,22);

			if($priv!=null){
				$edit=$priv->modify_priv==1 ?true:false;
				$del=$priv->del_priv==1 ?true:false;
			}

			if($edit){
				$action.=' <a class="dropdown-items update" href="javascript:void(0);" style="float:left" data-id="'.$id.'" ><i class="fa fa-edit fs-4"></i></a>';
			}

            if($del){
				$action.= '<a class="dropdown-items delete" href="javascript:void(0);" style="margin-left:10px;float:left" data-id="'.$id.'"><i class="fa fa-trash fs-4 text-danger"></i></a>';
			}

			$data_arr[] = array(
			  "id" => ++$start,
			  "desc" => $record->description,
			  "max_affilation_no" => $record->max_affilation_no,
              "action"=>$action
			);
		 }

		 $response = array(
			"draw" => intval($draw),
			"iTotalRecords" => $totalRecords,
			"iTotalDisplayRecords" => $totalRecordswithFilter,
			"aaData" => $data_arr
		 );

		 echo json_encode($response);
		 exit;
	}
	
	
}
