<?php

namespace App\Http\Controllers\admin\master;

use App\Http\Controllers\Controller;
use App\Imports\BoardImport;
use App\Models\Bard;
use App\Models\State;
use App\Providers\RouteServiceProvider;
use Hash;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Auth, Validator, Redirect;
use App\Models\Board;
use App\Components\BoardManager;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
class BoardController extends Controller
{
	
	public function index() 
	{
        $state=State::all();
		$boards=Bard::all();
		return view('admin/boards/index',['states'=>$state,'boards'=>$boards]);
	}
	
	public function save(Request $request)
	{

        try
		{
			if($request->isMethod('post'))
			{
				$params = $request->all();
				$messages = [
					'max' => 'User ID should not be greater than 50 characters.',
				];
				$validator = Validator::make($params,[
					'aff_no' =>'required|max:20|unique:school_affilation,aff_no|regex:/^[a-zA-Z0-9& ]+$/',
                    'board' =>'required|regex:/^[a-zA-Z0-9& ]+$/',
                    'school_name'=>'required|regex:/^[a-zA-Z0-9& ]+$/',
                    'pincode'=>'required|min:6',
                    'address'=>'required|regex:/^[a-zA-Z0-9& ]+$/',
                    'state'=>'required'
				], $messages);
				
				if($validator->fails())
				{
					return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
				}
				$departmentObj = BoardManager::getInstance();
				
                $params=[
                    'aff_no' =>$request->aff_no,
                    'board' =>$request->board,
                    'school_name'=>$request->school_name,
                    'pincode'=>$request->pincode,
                    'address'=>$request->address,
                    'state'=>$request->state,
                ];

				$status = $departmentObj->create($params);
				
				if($status)
				{
					return response()->json(array('status'=>'success'));
				}
				
				return response()->json(array('status'=>'error', 'error' => 'Something Wrong'));
			}
		
			return redirect('home')->with('error', 'Not valid');
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','error'=>$error));
		}

	}
	
	public function update(Request $request)
	{
        try
		{
			$params = $request->all();
				$messages = [
					'max' => 'User ID should not be greater than 50 characters.',
				];
				$validator = Validator::make($params,[
                    'aff_no' =>'required|max:20|regex:/^[a-zA-Z0-9& ]+$/',
                    'board' =>'required|regex:/^[a-zA-Z0-9& ]+$/',
                    'school_name'=>'required|regex:/^[a-zA-Z0-9& ]+$/',
                    'pincode'=>'required|min:6',
                    'address'=>'required|regex:/^[a-zA-Z0-9& ]+$/',
                    'state'=>'required'
				], $messages);
				
				if($validator->fails())
				{
					return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
				}
				$departmentObj = BoardManager::getInstance();
				
               
                $params=[
                    'aff_no' =>$request->aff_no,
                    'board' =>$request->board,
                    'school_name'=>$request->school_name,
                    'pincode'=>$request->pincode,
                    'address'=>$request->address,
                    'state'=>$request->state,
                ];

			$status = $departmentObj->updateById($request->id, $params);
			
			if($status)
			{
				return response()->json(array('status'=>'success', 'message' => 'Successfully Update.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError'));
		}
	}
	
	public function deleteById(Request $request)
	{
		try
		{
			$id = $request->id;
			$departmentObj = BoardManager::getInstance();
			$department = $departmentObj->getBoardById($id);
			
			if($department == null)
			{
				return response()->json(array('status'=>'error', 'message' => 'Record not found.'));
			}
			
			$status = $departmentObj->deleteById($id);
			
			if($status)
			{
				return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','error'=>$error));
		}
	}
	
	public function get(Request $request)
	{
		
		$id = $request->id;
		$departmentObj = Board::find($id);
		return response()->json(array('status'=>'success', 'data' =>$departmentObj ));
		
	}
	
	public function ajaxcall(Request $request)
	{
		 $draw = $request->get('draw');
		 $start = $request->get("start");
		 $rowperpage = $request->get("length");

		 $columnIndex_arr = $request->get('order');
		 $columnName_arr = $request->get('columns');
		 $order_arr = $request->get('order');
		 $search_arr = $request->get('search');

		 $columnIndex = $columnIndex_arr[0]['column'];
		 $columnName = $columnName_arr[$columnIndex]['data']; 
		 $columnSortOrder = $order_arr[0]['dir']; 
		 $searchValue = $search_arr['value']; 

		 $countData = Board::select('count(*) as allcount')
		              ->join('boards','boards.id','school_affilation.board');
		 
         
        if($searchValue != null) {
			$countData->where('school_affilation.school_name', 'like', '%' .$searchValue . '%')
            ->orWhere('school_affilation.aff_no', 'like', '%' .$searchValue . '%')
            ->orWhere('school_affilation.address', 'like', '%' .$searchValue . '%');
		}
		if($request->board_id!=null){
			$countData->where('school_affilation.board',  $request->board_id);
		}
		

		$totalRecordswithFilter = $countData->count();

		$totalRecords = $totalRecordswithFilter;
		$records = Board::select('school_affilation.*','boards.description as board_name')
		   ->join('boards','boards.id','school_affilation.board')
		   ->skip($start)
		   ->take($rowperpage)
		   ->orderBy('school_affilation.id','desc');

        if($searchValue != null) {
			$records->where('school_affilation.school_name', 'like', '%' .$searchValue . '%')
            ->orWhere('school_affilation.aff_no', 'like', '%' .$searchValue . '%')
            ->orWhere('school_affilation.address', 'like', '%' .$searchValue . '%');
		}
		if($request->board_id!=null){
			$records->where('school_affilation.board', $request->board_id);
		}
		$list = $records->get();

		$data_arr = array();
		 
		 foreach($list as $sno => $record){

			$id = $record->id;
			$code = '<a href="javascript:void(0);" style="" class="view" data-id="'.$id.'">'.$record->username.'</a>';
			$edit = asset('icon/edit2.png');
			$delete = asset('icon/del.png');
            $action='';

			$action='';

			$userid=Auth::guard('admin')->user()->id;

			$edit=$del=true;
			$priv=getUserHasRoleProgram($userid,21);

			if($priv!=null){
				$edit=$priv->modify_priv==1 ?true:false;
				$del=$priv->del_priv==1 ?true:false;
			}

			if($edit){
				$action.=' <a class="dropdown-items update" href="javascript:void(0);" style="float:left" data-id="'.$id.'" ><i class="fa fa-edit fs-4"></i></a>';
			}

			// if($del){
			// 	$action.= '<a class="dropdown-items delete" href="javascript:void(0);" style="margin-left:10px;float:left" data-id="'.$id.'"><i class="fa fa-trash fs-4"></i></a>';
			// }
			// $action = ' <a class="dropdown-items update" href="javascript:void(0);" style="float:left" data-id="'.$id.'" ><i class="fa fa-edit fs-4"></i></a>';			

			$data_arr[] = array(
			  "id" => ++$start,
			  "aff_no" => $record->aff_no,
			  "board" => $record->board_name,
              "school"=>$record->school_name,
              "address"=>$record->address,
              "action"=>$action
			);
		 }

		 $response = array(
			"draw" => intval($draw),
			"iTotalRecords" => $totalRecords,
			"iTotalDisplayRecords" => $totalRecordswithFilter,
			"aaData" => $data_arr
		 );

		 echo json_encode($response);
		 exit;
	}

    public function import(Request $request){

                $request->validate([
                      'file'=>'required|mimes:xlsx,xls',
                 ]);
                
                 $insert=Excel::import(new BoardImport, $request->file('file'));
                     
                
                   
                    return redirect()->back();
    }
	
	
}
