<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Mail\PasswordCreatedEmail;
use App\Mail\UserDomainEnquiryMail;
use App\Models\User;
use Carbon\Carbon;
use Redirect;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\File;
use mysqli;
use Throwable;
use Illuminate\Support\Str;
use \Mpdf\Mpdf as PDF;
use App\Models\LoginHistory;
use phpseclib3\Net\SFTP;
use Firebase\JWT\JWT;
use Config;
use \Firebase\JWT\Key;
use Log;
use App\Library\EPP;
use App\Models\Zone;
use App\Services\Formatters\BINDFormatter;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Artisan;
use App\Components\MailManager;

class HomeController extends Controller
{
  
    public function getpincode(Request $request)
    {
        $state = DB::table('cities')->select('cities.*','regions.description as state_name')->where('cities.pincode',$request->pincode)->join('regions','regions.id','cities.region_id')->first();
        return ['status'=>true, 'data'=>$state];
    }

    public function forgot()
    {
        return view('forgot');
    }

    public function forgotpass($token)
    {
        $obj = DB::table('users')->where('forgot_url', $token)->first();
        if(!$obj) {
            return redirect('forgot')->with('error', 'No record found');
        }
        
        return view('forgotchange', ['obj' => $obj]);
    }
    
    public function changeforgotpass(Request $request)
    {
        $params = $request->all();
        $message = [
            'confirmpassword.same' => "The confirm password and password didn't match."
        ];
        $rules = ['otp' =>'required', 'password' =>'required|min:8', 'confirmpassword' =>'same:password|min:8'];
        $validator = validator()->make($params, $rules,$message);
        if ($validator->fails())
        {
            return Redirect::back()->withErrors($validator->errors());
        }
        
        $obj = DB::table('users')->where('forgot_url', $request->url)->first();
        if(!$obj) {
            return redirect('user-login')->with('error', 'Opps! You have entered invalid credentials');
        }
        
        if($obj->forgot_otp != $request->otp) {
            return redirect('forgot-pass/'.$request->url)->with('error', 'Invalid OTP, Kindly, enter correct OTP');
        }
        
        $password = Hash::make($request->password);
        $status = DB::table('users')->where('id', $obj->id)->update([
            'password' => $password,
            'forgot_otp' => null,
            'forgot_url' => null
        ]);
        
        if($status)
        {
            return redirect('user-login')->with('success', 'You have successfully changed your password.');
        }
        
        return redirect('forgot-pass/'.$request->url)->with('error', 'Something wrong');
        
    }


    public function testApi()
    {
        
    }


    public function forgotsend(Request $request)
    {

        $params = $request->all();
        $messages = [
            'email.required' => 'Please enter user name.'
        ];
        $rules = ['email' =>'required'];
        $validator = validator()->make($params, $rules, $messages);
        if ($validator->fails())
        {
            return Redirect::back()->withErrors($validator->errors());
        }
        
        $obj = DB::table('users')->where('domainName', $request->email)->first();
        
        if($obj) {
          
                $contact=DB::table('user_contact_details')->where('user_id',$obj->id)->first();

                $passwordemail=$obj->email;

                if($contact!=null){
                    $jsondecode=json_decode($contact->administrative_detail,true);
                    $passwordemail=$jsondecode['email']??$obj->email;
                }
                $data = $this->sendMail($obj,$passwordemail);

                if($data['status'] = 'success') {
                    $msg = $data['message'];
                    return redirect('forgot')->with('success', $msg);
                } else if($data['status'] = 'false') {
                    return redirect('forgot')->with('error', $data['message']);
                }
        } else {
            return redirect('forgot')->with('error', 'Opps! You have entered invalid credentials');
            
        }

    }

    public function checkEmailSending(){

        dd(223);

    }


    private function sendMail($obj,$email)
    {
        
        $user_id = $obj->name;
        $to_email = $email;
        $domainname = $obj->domainName;
        $otp = mt_rand(1000, 9999);
        $string = encrypt($email); 
        
        $url = url('forgot-pass/'.$string);
        $data = array('user_id' => $user_id, 'email' => $to_email, 'url' => $url, 'body' => $otp, 'domainname'=>$domainname,'subject'=>"Password Reset Email for $domainname");
        
        try {

            $view = 'mail.forgot';

            $mailer = MailManager::getInstance();

            $status=$mailer->mailSender($view, $data);

            // dd($status);
            if($status){

                DB::table('users')->where('id', $obj->id)->update(['forgot_otp' => $otp, 'forgot_url' => $string]);
                $maskedEmail = $this->maskEmail($to_email);

                return array('status' => 'success', 'message' => "OTP is sent successfully to $maskedEmail Please check your email inbox/spam");

            }else{

                return array('status' => 'false', 'message' => 'Please try again after some time');
  
            }

              
        } catch (Throwable $e) {
        //  dd($e); 
        }

        return array('status' => 'false', 'message' => 'Please try again later');

    }


    private function callSMTP() {

        $data = DB::table('email_settings')->where('status', 1)->first();
        if($data) {

            $mail = [
                'transport' => 'smtp', 
                'host' => $data->host_name,
                'port' => $data->port_number,
                'encryption' => 'tls',
                'username' => $data->username,
                'password' => $data->password,
                'timeout' => null
            ];
            
      
              $from=[
                'address'=>$data->from_address,
                'name'=>$data->from_name
              ];
      
                config(['mail.mailers.smtp' => $mail]);
                config(['mail.from' => $from]);
      
              return true;
              
        }
          
          return false;
      
      }
      


    function maskEmail($email) {
        list($username, $domain) = explode('@', $email);
    
        $usernameLength = strlen($username);
    
        $maskedUsername = substr($username, 0, 1) . str_repeat('*', $usernameLength - 2) . substr($username, -1);
    
        $maskedEmail = $maskedUsername . '@' . $domain;
    
        return $maskedEmail;
    }


    public function user_email_verification($crpyUerId)
    {
        $data['title'] = 'User Registration';
        $user_id =base64_decode($crpyUerId);
        $user = User::where('id',$user_id)->where('status',0)->first();

        if(!$user){
            return 'Email Link Expired';
        }
        
        $user->email_verified_at = Carbon::now();
        $user->save();

        $data['user'] = User::find($user_id);
        Session::flash('message','Your email has been verified.');
        Session::flash('alert-class', 'alert-success');
        return view('user.pages/register',$data);
    }

    public function googleAuth(Request $request)
    {

        $request->validate([
            'userid' => 'required',
            'username' => 'required',
            'email' => 'required|email',
            'password' => 'required|confirmed|min:8|regex:"^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*#?&])[A-Za-z\d@$#!%*?&]{8,15}$"',
        ]);
        $google2fa = app('pragmarx.google2fa');

        $registration_data = $request->all();

        $registration_data["google2fa_secret"] = $google2fa->generateSecretKey();

        $request->session()->put('registration_data', $registration_data);

        $QR_Image = $google2fa->getQRCodeInline(
            config('app.name'),
            $registration_data['username'],
            $registration_data['google2fa_secret']
        );

        return view('google2fa.register', ['QR_Image' => $QR_Image, 'secret' => $registration_data['google2fa_secret']]);

    }

    public function usersavegoogleauth(Request $request){

        
        $request->merge(session('registration_data'));
        $google2fa = app('pragmarx.google2fa');


        $valid = $google2fa->verifyKey($request->input('google2fa_secret'), $request->input('one_time_password'),10);
        if ($valid){

            $data=Session::get('registration_data');

            $userid=Session::get('user_id');

            $user = User::find($userid);
            if ($user){
                $user->update(['google2fa_secret'=>$request->input('google2fa_secret')]);
            }else{
                Session::flash('message','User Not Found');
                Session::flash('alert-class', 'alert-danger');
                return redirect('user-login');
            }
            $user = User::find($userid);
            if ($user){

                $login_type = filter_var($user->domainName, FILTER_VALIDATE_EMAIL )
                    ? 'email'
                    : 'domainName';

                $request->merge([
                    $login_type => $user->domainName
                ]);

                $credentials = $request->only($login_type, 'password');
                $remember = ($request->has('remember')) ? true : false;
                if (Auth::attempt($credentials,$remember)) {
              
                    $token = Str::random(32);
                    Session::put('auth_token', $token);

                    $storetoken=DB::table('users')->where('id',Auth::user()->id)->update(['auth_token'=>$token]);

                    $request->session()->forget('registration_data');
                    Session::flash('message', 'Signed in!');
                    return redirect("user-dashboard");

                }else{

                    Session::flash('message','Incorrect Otp.');
                    Session::flash('alert-class', 'alert-danger');
                    return back();

                }
            }

        }else{
            Session::flash('message','Incorrect Otp.');
            Session::flash('alert-class', 'alert-danger');
            return back();
        }

    }

    public function user_create_password(Request $request)
    {

        $request->merge(session('registration_data'));
        $google2fa = app('pragmarx.google2fa');
        $valid = $google2fa->verifyKey($request->input('google2fa_secret'), $request->input('one_time_password'),10);
        if ($valid){
            $user = User::find($request->input('userid'));
            if ($user){
                $user->password = Hash::make($request->input('password'));
                $user->google2fa_secret = $request->input('google2fa_secret');
                $user->status = 1;
                $user->save();
            }else{
                Session::flash('message','User Not Found');
                Session::flash('alert-class', 'alert-danger');
                return redirect('user-login');
            }
            $user = User::find($request->input('userid'));
            if ($user){

                $login_type = filter_var($user->domainName, FILTER_VALIDATE_EMAIL )
                    ? 'email'
                    : 'domainName';

                $request->merge([
                    $login_type => $user->domainName
                ]);

                $credentials = $request->only($login_type, 'password');
                $remember = ($request->has('remember')) ? true : false;
                if (Auth::attempt($credentials,$remember)) {
              
                    $token = Str::random(32);
                    Session::put('auth_token', $token);

                    $storetoken=DB::table('users')->where('id',Auth::user()->id)->update(['auth_token'=>$token]);

                    $authuser=Auth::user();
                    $activity=['user_id'=>$authuser->id,'user_type'=>1,'user_name'=>$authuser->name,'domainName'=>$authuser->domainName,'status'=>'Domain Verfication','ip_address'=>$request->ip()];
                    handleActivity($activity);
                    
                    $request->session()->forget('registration_data');
                    Session::flash('message', 'Signed in!');
                    return redirect("user-dashboard");

                }else{
                    Session::flash('message','Incorrect Otp.');
                    Session::flash('alert-class', 'alert-danger');
                    return back();
                }
            }

        }else{
            Session::flash('message','Incorrect Otp.');
            Session::flash('alert-class', 'alert-danger');
            return back();
        }

    }

    public function checkEppLogin()
    {
        $host = 'epp.nixiregistry.in';
        $port = 700;

        $certFile = '/var/www/html/ernet/registry-key/800068-ernet.pem';
        $keyFile  = '/var/www/html/ernet/registry-key/800068-ernet.key';
        $caFile   = '/var/www/html/ernet/registry-key/ca-bundle.pem';

        
        $username = 'ernet_in'; 
        $password = '9e2dfbd06959e8'; 

        // Validate file paths
        foreach ([
            'Certificate' => $certFile,
            'Private Key' => $keyFile,
            'CA Bundle' => $caFile
        ] as $label => $file) {
            if (!file_exists($file)) {
                return response()->json([
                    'status' => 'error',
                    'message' => "$label file not found at $file"
                ]);
            }
        }

        // EPP login XML (without xml declaration per EPP spec)
        $xmlBody = <<<EOT
    <epp xmlns="urn:ietf:params:xml:ns:epp-1.0">
    <command>
        <login>
        <clID>{$username}</clID>
        <pw>{$password}</pw>
        <options>
            <version>1.0</version>
            <lang>en</lang>
        </options>
        <svcs>
            <objURI>urn:ietf:params:xml:ns:domain-1.0</objURI>
            <objURI>urn:ietf:params:xml:ns:contact-1.0</objURI>
            <objURI>urn:ietf:params:xml:ns:host-1.0</objURI>
        </svcs>
        </login>
        <clTRID>ABC-12345</clTRID>
    </command>
    </epp>
    EOT;

        // Add 4-byte length prefix as per EPP framing (length includes the 4 length bytes)
        $length = strlen($xmlBody) + 4;
        $prefix = pack('N', $length); // big-endian 32-bit unsigned int
        $xml = $prefix . $xmlBody;

        $context = stream_context_create([
            'ssl' => [
                'local_cert'        => $certFile,
                'local_pk'          => $keyFile,
                'cafile'            => $caFile,
                'verify_peer'       => true,
                'verify_peer_name'  => true,
                'allow_self_signed' => false,
            ]
        ]);

        $fp = @stream_socket_client(
            "tls://{$host}:{$port}",
            $errno,
            $errstr,
            30,
            STREAM_CLIENT_CONNECT,
            $context
        );

        if (!$fp) {
            return response()->json([
                'status' => 'error',
                'message' => "Failed to connect: $errstr ($errno)"
            ]);
        }

        stream_set_timeout($fp, 30);

        // Read the EPP greeting (length-prefixed)
        $greetingLengthRaw = fread($fp, 4);
        if (strlen($greetingLengthRaw) < 4) {
            fclose($fp);
            return response()->json([
                'status' => 'error',
                'message' => 'Failed to read greeting length from server'
            ]);
        }
        $greetingLength = unpack('N', $greetingLengthRaw)[1];
        $greetingBody = fread($fp, $greetingLength - 4);

        // Send the login XML with prefix
        fwrite($fp, $xml);

        // Read the login response (length-prefixed)
        $responseLengthRaw = fread($fp, 4);
        if (strlen($responseLengthRaw) < 4) {
            fclose($fp);
            return response()->json([
                'status' => 'error',
                'message' => 'Failed to read login response length from server'
            ]);
        }
        $responseLength = unpack('N', $responseLengthRaw)[1];
        $responseBody = fread($fp, $responseLength - 4);

        fclose($fp);

        return response()->json([
            'status' => 'success',
            'greeting' => trim($greetingBody),
            'login_response' => trim($responseBody)
        ]);
    }

    public function user_login()
    {
        $previousUrl = URL::previous();
        $uri_parts = explode('/', $previousUrl);
        $uri_tail = end($uri_parts);
        Session::put('previous_url', $uri_tail);
        if (Auth::check()){
            return redirect()->route('user.dashboard');
        }
        $data['title'] = 'User Login';
        return view('user.pages/login',$data);
    }

    public function google_auth_otp()
    {
       $data['title'] = 'User Login';
       return view('user.pages.google-auth-otp',$data);
    }

    public function googleauthregister(Request $request){

        $google2fa = app('pragmarx.google2fa');

        $registration_data=Session::get('login_data');

        $registration_data["google2fa_secret"] = $google2fa->generateSecretKey();
        
        $request->session()->put('registration_data', $registration_data);

        $QR_Image = $google2fa->getQRCodeInline(
            config('app.name'),
            $registration_data['email'],
            $registration_data['google2fa_secret']
        );

        return view('google2fa.authregister', ['QR_Image' => $QR_Image, 'secret' => $registration_data['google2fa_secret']]);

    }

    public function googleAuthLogin(Request $request)
    {

        $request->validate([
            'email' => 'required',
            'password' => 'required',
        ]);

        $login_type = filter_var($request->input('email'), FILTER_VALIDATE_EMAIL )
        ? 'domainName'
        : 'domainName';

    $request->merge([
        $login_type => $request->input('email')
    ]);

    $credentials = $request->only($login_type, 'password');

        if(Auth::attempt($credentials)){
            $registration_data = $request->all();
            Session::put('login_data', $registration_data);

            if(Auth::user()->google2fa_secret==null){

            $userId=Auth::user()->id;

            Session::put('user_id', $userId);

            Auth::logout();

            return response()->json(array('status'=>'googleauth_register', 'message' => 'Please Register for Google Auth','user_id'=>$userId));


            }else if (Auth::user()->active_session_token==null) {
            $sessionToken = Str::random(32); 
            Session::put('auth_active_token', $sessionToken);
            $storetoken=DB::table('users')->where('id',Auth::user()->id)->update(['active_session_token'=>$sessionToken,'last_login_ip'=>$request->ip()]);
            
            return response()->json(array('status'=>'success', 'message' => 'Please verify otp.'));
            
        }
        else
        {

            return response()->json(array('status'=>'samelogin', 'message' => 'Active Session Found'));
            
        }
        }  else{
        return response()->json(array('status'=>'error', 'message' => 'Login details are not valid!'));
        
        }       
  
           
  
    }


    public function downloadinvoice($id){

        $id=base64_decode($id);

        $transactions = DB::table('transactions')->where('user_id',$id)->get();
        $user = DB::table('users')->where('id',$id)->first();
        $user_detail = DB::table('user_contact_details')->where('user_id',$id)->first();
        
        view()->share('user', $user);
        view()->share('transactions', $transactions);
        view()->share('user_detail', $user_detail);

            $view_path = 'inv';
            $downloadname = 'invoice';

            $mpdf = new PDF(['utf-8', 'A4-C','L']);

            $mpdf->WriteHTML(view('document.' . $view_path));

            $pdfFilePath = public_path('temp_invoice.pdf');
            $mpdf->Output($pdfFilePath, 'F');

            Mail::send('front.email.test', ['transactions' => $transactions], function ($message) use ($user, $pdfFilePath) {
                 $message->to('abhishek.gupta@intileo.com')
                 ->subject('Invoice')
                 ->attach($pdfFilePath, [
                  'as' => 'invoice.pdf',
                 'mime' => 'application/pdf',
                 ]);
            });
                
            unlink($pdfFilePath);

    }

    public function customLogin(Request $request)
    {
        $previousUrl = Session::get('previous_url');
        $olddata=Session::get('login_data');
        $request->merge($olddata);
        $google2fa = app('pragmarx.google2fa');
       
        $login_type = filter_var($request->input('email'), FILTER_VALIDATE_EMAIL )
            ? 'email'
            : 'domainName';

        $request->merge([
            $login_type => $request->input('email')
        ]);

        $credentials = $request->only($login_type, 'password');

        $remember = ($request->has('remember')) ? true : false;
        if (Auth::attempt($credentials,$remember)) {

            $token = Str::random(32);
            Session::put('auth_token', $token);

            $storetoken=DB::table('users')->where('id',Auth::user()->id)->update(['auth_token'=>$token,'last_login_ip'=>$request->ip()]);
            $this->loginHistory(Auth::user()->id);
            $valid = $google2fa->verifyKey(Auth::user()->google2fa_secret, $request->input('one_time_password'),16);
            if ($valid==true){

                Session::flash('message', 'Signed in!');
                if($previousUrl=="vas"){
                    Session::forget('previous_url');
                    return redirect("l-mass");
                }elseif($previousUrl=="e-wass"){
                    
                    if(Session::get('current_url')!="" && Session::get('current_url')=="colleges"){
                        
                        Session::forget('current_url');
                        Session::forget('previous_url');
                        return redirect("colleges");
                    }elseif(Session::get('current_url')!="" && Session::get('current_url')=="schools"){
                    
                        Session::forget('previous_url');
                        Session::forget('current_url');
                        return redirect("schools");
                    }else{
                        Session::forget('previous_url');
                        Session::forget('current_url');
                        return redirect("universities");
                    }
                    
                   
                }else{
                    //dd($previousUrl);
                    return redirect("user-dashboard");
                }
            }else{
                Session::flash('message', 'Incorrect Authorization Code');
                Session::flash('alert-class', 'alert-danger');
                Auth::logout();
                return redirect("user-login");
            }

        }
        Session::flash('message', 'Login details are not valid!');
        return redirect("user-login");
    }

    //not in use
    public function customRegistration(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'password' => 'required|min:6',
        ]);

        $data = $request->all();
        $check = $this->create($data);
        Session::flash('message', 'You have signed-in!');
        return redirect("user-dashboard");
    }
    public function create(array $data)
    {
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password'])
        ]);
    }

    public function projects()
    {
         $projects =  DB::table('projects')->where('user_id','=', Auth::id())->get();

         $temp_publish_data = DB::table('users')->where('id','=', Auth::id())->first();
        
         $paymentDoneByUser = DB::table('transactions')->where('user_id','=',Auth::id())->where('transaction_type', 'elmaas')->count();

         $ewaaspaymentDoneByUser = DB::table('transactions')->where('user_id','=',Auth::id())->where('transaction_type', 'ewaas')->count();
        
         return view('front.project',compact('projects','paymentDoneByUser','ewaaspaymentDoneByUser','temp_publish_data'));
    }

    public function createLmassClone(Request $request)
    {
        
        try {
            $projectCreatedByUser = DB::table('projects')->where('vas_type','=','elmaas')->where('user_id','=',Auth::id())->count();
           if ($projectCreatedByUser >=2){
               return ['status'=>false, 'msg'=>'You have already created 2 templates, if you want to create another one then please remove existing one'];
           }

         
            $dir_path = $request->projectName.'_'.Auth::user()->id;
            
            $projectExist = DB::table('projects')->where('project_name','=',$dir_path)->first();
            if ($projectExist != null){
                return ['status'=>false, 'msg'=>'Template file already created!'];
            }

            $file_status = File::exists('/opt/bitnami/apache/htdocs/drupal/'.$request->projectName.'.zip'); //Storage::disk('drupal')->path('lmass_temp_1.zip'));
            if ($file_status) {
                $zip = new \ZipArchive();
                $zipFile = $zip->open('/opt/bitnami/apache/htdocs/drupal/'.$request->projectName.'.zip');//Storage::disk('drupal')->path('lmass_temp_1.zip'));
                if ($zipFile === TRUE) {
                    ini_set('max_execution_time', 1024);
                    $zipStatus = $zip->extractTo('/opt/bitnami/apache/htdocs/drupal/'.$dir_path);
                    $zip->close();
                    if ($zipStatus){
                        $databaseName = $request->projectName.'_'.Auth::user()->id;
                        $username = 'root';//'lmass_t_1_'.Auth::user()->name;
                        $password = 'QWOBELwZu3T@';//Auth::user()->name.'@123';
                        $project_image = $request->projectName.'.'.'png';
                        $status = DB::table('projects')->insert([
                            'user_id'=> Auth::id(),
                            'project_name'=> $dir_path,
                            'db_name'=> strtolower($databaseName),
                            'db_username'=> $username,
                            'db_password'=> $password,
                            'project_image'=>$project_image,
                            'vas_type'=>'elmaas'
                        ]);
                        return ['status'=>true, 'msg'=>'Template File Created!'];
                    }else{
                        return ['status'=>true, 'msg'=>'Template not Created Because of File Permission!'];
                    }

                }

            } else {
                return ['status'=>false, 'msg'=>'Source File Not exit!'];
            }

        } catch (Throwable $e) {
            return ['status'=>false, 'msg'=>$e->getMessage()];
        }
    }

    public function importLmassDb(Request $request)
    {
        try {
            $databaseName = $request->projectName.'_'.Auth::user()->id;
            $username = 'root';//'lmass_t_1_'.Auth::user()->name;
            $password = 'QWOBELwZu3T@';//Auth::user()->name.'@123';

            $status = DB::statement("DROP DATABASE IF EXISTS $databaseName");
            $status = DB::statement("CREATE DATABASE IF NOT EXISTS $databaseName");
            ini_set('max_execution_time', 1024);
            $conn =new mysqli('localhost', 'root', 'QWOBELwZu3T@' , $databaseName);
            $conn->query('SET GLOBAL max_allowed_packet=1073741824;');
            $query = '';
            $sqlScript = file('/opt/bitnami/apache/htdocs/drupal/'.$request->projectName.'.sql');//Storage::disk('drupal')->path('lmass_temp_1.sql')) ;
            if($sqlScript){
                foreach ($sqlScript as $line)   {
                    $startWith = substr(trim($line), 0 ,2);
                    $endWith = substr(trim($line), -1 ,1);
    
                    if (empty($line) || $startWith == '--' || $startWith == '/*' || $startWith == '//') {
                        continue;
                    }
                    $query = $query . $line;
                    if ($endWith == ';') {
                        $conn->query('SET GLOBAL max_allowed_packet=1073741824;');
                        mysqli_query($conn,$query) or die('<div class="error-response sql-import-response">Problem in executing the SQL query <b>' . $query. '</b></div>');
                        $query= '';
                    }
                }
            }else{
                return ['status'=>false, 'msg'=>'Source File Not exit!'];
            }
            $dir_path = $request->projectName.'_'.Auth::user()->id;
          
            $databaseName = $request->projectName.'_'.Auth::user()->id;
          
            $username = 'root';//'lmass_t_1_'.Auth::user()->name;
            $password = 'QWOBELwZu3T@';//Auth::user()->name.'@123';
            $content = file_get_contents('/opt/bitnami/apache/htdocs/drupal/'.$dir_path.'/sites/default/settings.php'); //Storage::disk('drupal')->path($path.'\sites\default\settings.php'));
            $searchReplacePairs = [
                "u941538925_VAS" => strtolower($databaseName),
                "u123456789_SAV" =>  $username,
                "Test143" => $password,
                "FALSE"=>"TRUE",
                "'^lmass\.aviraorganics\.com$',"=>"'^3\.109\.5\.144$',",
                "'^.+\.lmass\.aviraorganics\.com$',"=>"'^.+\.3\.109\.5\.144\.drupal$','^.+\.3\.109\.5\.144\.drupal\.'.$dir_path.'$',",
            ];
            foreach ($searchReplacePairs as $search => $replace) {
                $content = str_replace($search, $replace, $content);
                file_put_contents('/opt/bitnami/apache/htdocs/drupal/'.$dir_path.'/sites/default/settings.php', $content);//Storage::disk('drupal')->path($path.'\sites\default\settings.php'), $content);
            }
            $user_id = Auth::id();
            $obj = DB::table('users')->where('id', $user_id)->first();
            if($obj) {
            $data = $this->sendCreateTemplateMail($obj);
            }else
            {
                return ['status'=>false, 'msg'=>'Email error'];
            }
            return ['status'=>true, 'msg'=>'Template is ready to use'];
        }
         catch (Throwable $e) {
            return ['status'=>false, 'msg'=>$e->getMessage()];
        }
    }

    public function createEwaasClone(Request $request)
    {
        
        try {
            $projectCreatedByUser = DB::table('projects')->where('vas_type','=','ewaas')->where('user_id','=',Auth::id())->count();
           if ($projectCreatedByUser >=2){
               return ['status'=>false, 'msg'=>'You have already created 2 templates, if you want to create another one then please remove existing one'];
           }

           $dir_path = $request->projectName.'_'.Auth::user()->id;
            
            $projectExist = DB::table('projects')->where('project_name','=',$dir_path)->first();
            if ($projectExist != null){
                return ['status'=>false, 'msg'=>'Template file already created!'];
            }

            $file_status = File::exists('/opt/bitnami/apache/htdocs/drupal/'.$request->projectName.'.zip'); //Storage::disk('drupal')->path('lmass_temp_1.zip'));
            if ($file_status) {
                $zip = new \ZipArchive();
                $zipFile = $zip->open('/opt/bitnami/apache/htdocs/drupal/'.$request->projectName.'.zip');//Storage::disk('drupal')->path('lmass_temp_1.zip'));
                if ($zipFile === TRUE) {
                    ini_set('max_execution_time', 1024);
                    $zipStatus = $zip->extractTo('/opt/bitnami/apache/htdocs/drupal/'.$dir_path);
                    $zip->close();
                    if ($zipStatus){
                        $databaseName = $request->projectName.'_'.Auth::user()->id;
                        $username = 'root';//'lmass_t_1_'.Auth::user()->name;
                        $password = 'QWOBELwZu3T@';//Auth::user()->name.'@123';
                        $project_image = $request->projectName.'.'.'png';
                        $status = DB::table('projects')->insert([
                            'user_id'=> Auth::id(),
                            'project_name'=> $dir_path,
                            'db_name'=> strtolower($databaseName),
                            'db_username'=> $username,
                            'db_password'=> $password,
                            'project_image'=>$project_image,
                            'vas_type'=>'ewaas'
                        ]);
                        return ['status'=>true, 'msg'=>'Template File Created!'];
                    }else{
                        return ['status'=>true, 'msg'=>'Template not Created Because of File Permission!'];
                    }

                }

            } else {
                return ['status'=>false, 'msg'=>'Source File Not exit!'];
            }

        } catch (Throwable $e) {
            return ['status'=>false, 'msg'=>$e->getMessage()];
        }
    }
    public function importEwaasDb(Request $request)
    {
        try {
          
            $databaseName = $request->projectName.'_'.Auth::user()->id;
            $username = 'root';//'lmass_t_1_'.Auth::user()->name;
            $password = 'QWOBELwZu3T@';//Auth::user()->name.'@123';

            $status = DB::statement("DROP DATABASE IF EXISTS $databaseName");
            $status = DB::statement("CREATE DATABASE IF NOT EXISTS $databaseName");

            ini_set('max_execution_time', 1024);
            $conn =new mysqli('localhost', 'root', 'QWOBELwZu3T@' , $databaseName);
            $conn->query('SET GLOBAL max_allowed_packet=1073741824;');
            $query = '';
            $sqlScript = file('/opt/bitnami/apache/htdocs/drupal/'.$request->projectName.'.sql');//Storage::disk('drupal')->path('lmass_temp_1.sql')) ;
            if($sqlScript){
                foreach ($sqlScript as $line)   {
                    $startWith = substr(trim($line), 0 ,2);
                    $endWith = substr(trim($line), -1 ,1);
    
                    if (empty($line) || $startWith == '--' || $startWith == '/*' || $startWith == '//') {
                        continue;
                    }
                    $query = $query . $line;
                    if ($endWith == ';') {
                        $conn->query('SET GLOBAL max_allowed_packet=1073741824;');
                        mysqli_query($conn,$query) or die('<div class="error-response sql-import-response">Problem in executing the SQL query <b>' . $query. '</b></div>');
                        $query= '';
                    }
                }
            }else{
                return ['status'=>false, 'msg'=>'Source File Not exit!'];
            }
            $dir_path = $request->projectName.'_'.Auth::user()->id;
            $databaseName = $request->projectName.'_'.Auth::user()->id;
            $username = 'root';//'lmass_t_1_'.Auth::user()->name;
            $password = 'QWOBELwZu3T@';//Auth::user()->name.'@123';
            $content = file_get_contents('/opt/bitnami/apache/htdocs/drupal/'.$dir_path.'/sites/default/settings.php'); //Storage::disk('drupal')->path($path.'\sites\default\settings.php'));
            $searchReplacePairs = [
                "u941538925_VAS" => strtolower($databaseName),
                "u123456789_SAV" =>  $username,
                "Test143" => $password,
                "FALSE"=>"TRUE",
                "'^lmass\.aviraorganics\.com$',"=>"'^3\.109\.5\.144$',",
                "'^.+\.lmass\.aviraorganics\.com$',"=>"'^.+\.3\.109\.5\.144\.drupal$','^.+\.3\.109\.5\.144\.drupal\.'.$dir_path.'$',",
            ];
            foreach ($searchReplacePairs as $search => $replace) {
                $content = str_replace($search, $replace, $content);
                file_put_contents('/opt/bitnami/apache/htdocs/drupal/'.$dir_path.'/sites/default/settings.php', $content);//Storage::disk('drupal')->path($path.'\sites\default\settings.php'), $content);
            }
            $user_id = Auth::id();
            $obj = DB::table('users')->where('id', $user_id)->first();
            if($obj) {
            $data = $this->sendCreateTemplateMail($obj);
            }else
            {
                return ['status'=>false, 'msg'=>'Email error'];
            }
            return ['status'=>true, 'msg'=>'Template is ready to use'];
        }
         catch (Throwable $e) {
            return ['status'=>false, 'msg'=>$e->getMessage()];
        }
    }

    private function sendCreateTemplateMail($obj)
    {
        
        $user_id = $obj->name;
        $to_email = $obj->email;
        
        $data = array('user_id' => $user_id, 'email' => $to_email);
        
            Mail::send('mail.check', $data, function($message)use($data)
            {
                $message->to($data["email"], $data["user_id"])
                ->subject("Ernet");
            });

            if (Mail::flushMacros())
            {
                return array('status' => 'false', 'message' => 'Mail not send');
            }
            else
            {       
                return array('status' => 'success', 'message' => 'credentials has been sent successfully to your registered email id. Please check your email');
            }
    }
    public function removeproject(Request $request)
    {
        $params = $request->all();
        $messages = [
            'otp.required' => 'Please enter otp.'
        ];
        $rules = ['otp' =>'required'];
        $validator = validator()->make($params, $rules, $messages);
        if ($validator->fails())
        {
            return Redirect::back()->withErrors($validator->errors());
        }
        
        $user_id = Auth::id();
        $obj = DB::table('users')->where('id', $user_id)->first();

        if($obj->temp_del_otp != $request->otp) {
            return redirect('verifyremoveproject')->with('error', 'Invalid OTP, Kindly, enter correct OTP');
        }else
        {
            $project_id  = $obj->temp_del_id;
                if ($project_id != null){
                    try {
                        $pro = DB::table('projects')->where('id','=',$project_id)->first();
                        $path = $pro->project_name;
                        $file_status = File::exists('/opt/bitnami/apache/htdocs/drupal/'.$path);//Storage::disk('drupal')->path($path));
                        if ($file_status) {
                            ini_set('max_execution_time', 1024);
                            $status = File::deleteDirectory('/opt/bitnami/apache/htdocs/drupal/'.$path);//Storage::disk('drupal')->path($path));
                        }
                        $databaseName = $pro->db_name;
                        $status = DB::statement("DROP DATABASE $databaseName");
                        DB::table('projects')->where('id','=',$project_id)->delete();
                        $status = DB::table('users')->where('id', $obj->id)->update([
                                    'temp_del_otp' => null,
                                    'temp_del_id' => null
                                ]);
                        return redirect('projects')->with('success', 'Template Removed Successfully.');
                        Session::flash('message','Template Removed Successfully..');
                        Session::flash('alert-class', 'alert-success');
                        
                    }catch (Throwable $e) {
                        return redirect('projects')->with('error', 'Something went wrong');
                        
                    }

                }

        }
        
    }

    public function removeprojectstatusewaas(Request $request)
    {
        $project_id  = $request->projectId;
        $user_id = Auth::id();
        $obj = DB::table('users')->where('id', $user_id)->first();
        if($obj) {
            
                $data = $this->sendMailTempRemoveEwaas($obj,$project_id);
                if($data['status'] = 'success') {
                   
                    return ['status'=>true, 'msg'=>'OTP has been sent successfully. '];
                    
                } else if($data['status'] = 'false') {
                    return ['status'=>false, 'msg'=>'Error '];
                }
            
        } else {
            return redirect('forgot')->with('error', 'Incorrect details.');
        }
    }
    private function sendMailTempRemoveEwaas($obj,$project_id)
    {
        $user_id = $obj->name;
        $to_email = $obj->email;
        $otp = mt_rand(1000, 9999);
        
        $data = array('user_id' => $user_id, 'email' => $to_email,'body' => $otp);
        
            Mail::send('mail.tempewaasotp', $data, function($message)use($data)
            {
                $message->to($data["email"], $data["user_id"])
                ->subject("Ernet");
            });

            if (Mail::flushMacros())
            {
                return array('status' => 'false', 'message' => 'Mail not send');
            }
            else
            {       
                DB::table('users')->where('id', $obj->id)->update(['ewaas_temp_del_otp' => $otp, 'ewaas_temp_del_id' => $project_id]);
                return array('status' => 'success', 'message' => 'OTP is sent successfully to your registered email id Please check your email');
            }
    }
    public function verifyremoveprojectewaas(Request $request)
    {
        return view('user.pages/verifyotpewaas');
        
    }

    private function loginHistory($userId)
	{
		$obj = LoginHistory::where('user_id', $userId)->where('logout', 0)->first();
		if($obj == null)
		{
			$datetime = date('Y-m-d H:i:s');
			LoginHistory::create(['user_id' => $userId, 'login_time' => $datetime]);
		}else {
			if($obj->logout == 0) {
				$pkid = $obj->id;
				$datetime1 = $obj->login_time;
				$datetime2 = date('Y-m-d H:i:s');
				
				$time1 = strtotime($datetime1);
				$time2 = strtotime($datetime2);
				
				$diff =  abs(strtotime($datetime1) - strtotime($datetime2));
				$difftext = seconds2human($diff);
				$durationCount = 0;
				
				$result = LoginHistory::where('user_id', $userId)->get();
				foreach($result as $resultdata) {
					$durationCount += $resultdata->duration;
				}
				
				if($durationCount == 0)
				{
					$isUpdate =	LoginHistory::where('id', $pkid)->update(
						[
							'logout_time' => $datetime2,
							'duration' => $diff,
							'duration_time' => $difftext,
							'total_duration' => $diff,
							'total_duration_time' => $difftext,
							'logout' => 1
						]
					);
				}
				else
				{
					$datetime1 = $obj->login_time;
					$datetime2 = date('Y-m-d H:i:s');
					
					$time1 = strtotime($datetime1);
					$time2 = strtotime($datetime2);
					$diff =  abs(strtotime($datetime1) - strtotime($datetime2));
					$difftext =	seconds2human($diff);
					$durationCountsum = $durationCount+$diff;
					$durationCountdifftext = seconds2human($durationCountsum);
					
						$isUpdate =	LoginHistory::where('id', $pkid)->update(
						[
							'logout_time' => $datetime2,
							'duration' => $diff,
							'duration_time' => $difftext,
							'total_duration' => $durationCountsum,
							'total_duration_time' => $difftext,
							'logout' => 1
						]
					);
				}
				
				if($isUpdate) {
					$datetime = date('Y-m-d H:i:s');
					LoginHistory::create(['user_id' => $userId, 'login_time' => $datetime]);
				}
				
			} else {
				$datetime = date('Y-m-d H:i:s');
				LoginHistory::create(['user_id' => $userId, 'login_time' => $datetime]);
			}
		}
	}
    public function removeprojectewaas(Request $request)
    {
        $params = $request->all();
        $messages = [
            'otp.required' => 'Please enter otp.'
        ];
        $rules = ['otp' =>'required'];
        $validator = validator()->make($params, $rules, $messages);
        if ($validator->fails())
        {
            return Redirect::back()->withErrors($validator->errors());
        }
        
        $user_id = Auth::id();
        $obj = DB::table('users')->where('id', $user_id)->first();

        if($obj->ewaas_temp_del_otp != $request->otp) {
            return redirect('verifyremoveprojectewaas')->with('error', 'Invalid OTP, Kindly, enter correct OTP');
        }else
        {
            $project_id  = $obj->ewaas_temp_del_id;
                if ($project_id != null){
                    try {
                        //delete project folder
                        $pro = DB::table('projects')->where('id','=',$project_id)->first();
                        $path = $pro->project_name;
                        $file_status = File::exists('/opt/bitnami/apache/htdocs/drupal/'.$path);//Storage::disk('drupal')->path($path));
                        if ($file_status) {
                            ini_set('max_execution_time', 1024);
                            $status = File::deleteDirectory('/opt/bitnami/apache/htdocs/drupal/'.$path);//Storage::disk('drupal')->path($path));
                        }
                        $databaseName = $pro->db_name;
                        $status = DB::statement("DROP DATABASE $databaseName");
                        DB::table('projects')->where('id','=',$project_id)->delete();
                        $status = DB::table('users')->where('id', $obj->id)->update([
                                    'ewaas_temp_del_otp' => null,
                                    'ewaas_temp_del_id' => null
                                ]);
                        return redirect('projects')->with('success', 'Template Removed Successfully.');
                        Session::flash('message','Template Removed Successfully..');
                        Session::flash('alert-class', 'alert-success');
                        
                    }catch (Throwable $e) {
                        return redirect('projects')->with('error', 'Something went wrong');
                        
                    }

                }

        }
        
    }
    public function removeprojectstatus(Request $request)
    {
        $project_id  = $request->projectId;
        $user_id = Auth::id();
        $obj = DB::table('users')->where('id', $user_id)->first();
        if($obj) {
            
                $data = $this->sendMailTempRemove($obj,$project_id);
                if($data['status'] = 'success') {
                   
                    return ['status'=>true, 'msg'=>'OTP has been sent successfully. '];
                    
                } else if($data['status'] = 'false') {
                    return ['status'=>false, 'msg'=>'Error '];
                }
            
        } else {
            return redirect('forgot')->with('error', 'Incorrect details.');
        }

        
        
    }

    public function publishprojectstatus(Request $request)
    {
        $project_id  = $request->projectId;
        $user_id = Auth::id();
        $obj = DB::table('users')->where('id', $user_id)->first();
        if($obj) {
            
                $data = $this->sendMailTempPublish($obj,$project_id);
                if($data['status'] = 'success') {
                   
                    return ['status'=>true, 'msg'=>'OTP has been sent successfully. '];
                    
                } else if($data['status'] = 'false') {
                    return ['status'=>false, 'msg'=>'Error '];
                }
            
        } else {
            return redirect('forgot')->with('error', 'Incorrect details.');
        }

    }
    
    private function sendMailTempPublish($obj,$project_id)
    {
        $user_id = $obj->name;
        $to_email = $obj->email;
        $otp = mt_rand(1000, 9999);
        $data = array('user_id' => $user_id, 'email' => $to_email,'body' => $otp);
        
            Mail::send('mail.temppublishotp', $data, function($message)use($data)
            {
                $message->to($data["email"], $data["user_id"])
                ->subject("Ernet");
            });

            if (Mail::flushMacros())
            {
                return array('status' => 'false', 'message' => 'Mail not send');
            }
            else
            {       
                DB::table('users')->where('id', $obj->id)->update(['temp_publish_otp' => $otp,'temp_publish_id' => $project_id]);
                return array('status' => 'success', 'message' => 'OTP has been sent successfully to your registered email id.Please check your email');
            }
    }
    private function sendMailTempRemove($obj,$project_id)
    {
        $user_id = $obj->name;
        $to_email = $obj->email;
        $otp = mt_rand(1000, 9999);
        
        $data = array('user_id' => $user_id, 'email' => $to_email,'body' => $otp);
        
            Mail::send('mail.tempotp', $data, function($message)use($data)
            {
                $message->to($data["email"], $data["user_id"])
                ->subject("Ernet");
            });

            if (Mail::flushMacros())
            {
                return array('status' => 'false', 'message' => 'Mail not send');
            }
            else
            {       
                DB::table('users')->where('id', $obj->id)->update(['temp_del_otp' => $otp, 'temp_del_id' => $project_id]);
                return array('status' => 'success', 'message' => 'OTP is sent successfully to your registered email id Please check your email');
            }
    }

    public function publishproject(Request $request)
    {
        $params = $request->all();
        $messages = [
            'otp.required' => 'Please enter otp.'
        ];
        $rules = ['otp' =>'required'];
        $validator = validator()->make($params, $rules, $messages);
        if ($validator->fails())
        {
            return Redirect::back()->withErrors($validator->errors());
        }
        
        $user_id = Auth::id();
        $obj = DB::table('users')->where('id', $user_id)->first();

        if($obj->temp_publish_otp != $request->otp) {
            return redirect('verifypublishproject')->with('error', 'Invalid OTP, Kindly, enter correct OTP');
        }else
        {
            
            $project_id  = $obj->temp_publish_id;
                if ($project_id != null){
                    try {


                        $delete_template_data = DB::table('projects')->where('id','!=',$project_id)->where('vas_type','=','elmaas')->where('user_id','=',$user_id)->first();
                        
                        if($delete_template_data !=null){
                        $path = $delete_template_data->project_name;
                        $delete_project_id = $delete_template_data->id;
                        
                        $file_status = File::exists('/opt/bitnami/apache/htdocs/drupal/'.$path);//Storage::disk('drupal')->path($path));
                        if ($file_status) {
                            ini_set('max_execution_time', 1024);
                            $status = File::deleteDirectory('/opt/bitnami/apache/htdocs/drupal/'.$path);//Storage::disk('drupal')->path($path));
                        }
                        $databaseName = $delete_template_data->db_name;
                        $status = DB::statement("DROP DATABASE $databaseName");
                        DB::table('projects')->where('id','=',$delete_project_id)->delete();
                        }

                        
                        $pro = DB::table('projects')->where('id','=',$project_id)->where('vas_type','=','elmaas')->first();
                        $old_project_name = '/opt/bitnami/apache/htdocs/drupal/'.$pro->project_name;
                        $new_project_name = '/opt/bitnami/apache/htdocs/drupal/'.'elmaas.'.$obj->domainName;
                        DB::table('projects')->where('user_id', $obj->id)
                                             ->where('id', $project_id)
                                             ->where('vas_type','=','elmaas')
                                             ->update(['old_project_name' => $pro->project_name,'project_name' => 'elmaas.'.$obj->domainName,'status'=> '1']);
                        $status = DB::table('users')->where('id', $obj->id)->update([
                                    'temp_publish_otp' => null,
                                    'temp_publish_status'=>1,
                                ]);
                      
                        rename( $old_project_name, $new_project_name);
                        return redirect('projects')->with('success', 'Template Published Successfully.');
                        Session::flash('message','Template Published Successfully..');
                        Session::flash('alert-class', 'alert-success');

                        

                        }catch (Throwable $e) {
                        return redirect('projects')->with('error', 'Something went wrong');
                        
                    }
                }

        }
        
    }
    public function verifyremoveproject(Request $request)
    {
        return view('user.pages/verifyotp');
    }
    public function verifypublishproject(Request $request)
    {
        
        return view('user.pages/verifyotppublish');
        
    }
    public function universitiescat(Request $request){
        Session::put('current_url', $request->ewass);
        return redirect('universities');
    }
    public function schoolscat(Request $request){
        Session::put('current_url', $request->ewass);
        return redirect('schools');
        
    }
    public function collegescat(Request $request){
        Session::put('current_url', $request->ewass);
        return redirect('colleges');
    }

    public function unpublishprojectstatus(Request $request)
    {
        $project_id  = $request->projectId;
        $user_id = Auth::id();
        $obj = DB::table('users')->where('id', $user_id)->first();
        if($obj) {
            
                $data = $this->sendMailTempUnpublish($obj,$project_id);
                if($data['status'] = 'success') {
                   
                    return ['status'=>true, 'msg'=>'OTP has been sent successfully. '];
                    
                } else if($data['status'] = 'false') {
                    return ['status'=>false, 'msg'=>'Error '];
                }
            
        } else {
            return redirect('forgot')->with('error', 'Incorrect details.');
        }

    }
  
    private function sendMailTempUnpublish($obj,$project_id)
    {
        $user_id = $obj->name;
        $to_email = $obj->email;
        $otp = mt_rand(1000, 9999);
        $data = array('user_id' => $user_id, 'email' => $to_email,'body' => $otp);
        
            Mail::send('mail.tempunpublishotp', $data, function($message)use($data)
            {
                $message->to($data["email"], $data["user_id"])
                ->subject("Ernet");
            });

            if (Mail::flushMacros())
            {
                return array('status' => 'false', 'message' => 'Mail not send');
            }
            else
            {       
                DB::table('users')->where('id', $obj->id)->update(['temp_unpublish_otp' => $otp,'temp_unpublish_id' => $project_id,'temp_publish_id' => null]);
                return array('status' => 'success', 'message' => 'OTP has been sent successfully to your registered email id.Please check your email');
            }
    }
    public function verifyunpublishproject(Request $request)
    {
        
        return view('user.pages/verifyotpunpublish');
        
    }
    public function unpublishproject(Request $request)
    {
        $params = $request->all();
        $messages = [
            'otp.required' => 'Please enter otp.'
        ];
        $rules = ['otp' =>'required'];
        $validator = validator()->make($params, $rules, $messages);
        if ($validator->fails())
        {
            return Redirect::back()->withErrors($validator->errors());
        }
        
        $user_id = Auth::id();
        $obj = DB::table('users')->where('id', $user_id)->first();

        if($obj->temp_unpublish_otp != $request->otp) {
            return redirect('verifyunpublishproject')->with('error', 'Invalid OTP, Kindly, enter correct OTP');
        }else
        {
            $project_id  = $obj->temp_unpublish_id;
                if ($project_id != null){
                    try {
                        
                        $pro = DB::table('projects')->where('id','=',$project_id)->first();
                        $project_name = '/opt/bitnami/apache/htdocs/drupal/'.$pro->project_name;
                        $old_project_name = '/opt/bitnami/apache/htdocs/drupal/'.$pro->old_project_name;
                        DB::table('projects')->where('user_id', $obj->id)
                                             ->where('id', $project_id)
                                             ->update(['old_project_name' => $pro->project_name,'project_name' =>$pro->old_project_name,'status'=> '0']);
                        $status = DB::table('users')->where('id', $obj->id)->update([
                                    'temp_unpublish_otp' => null,
                                    'temp_publish_status'=> '0'
                                ]);
                        rename( $project_name,$old_project_name);
                        return redirect('projects')->with('success', 'Template Unpublished Successfully.');
                        Session::flash('message','Template Unpublished Successfully..');
                        Session::flash('alert-class', 'alert-success');

                        

                        }catch (Throwable $e) {
                        return redirect('projects')->with('error', 'Something went wrong');
                        
                    }
                }
        }
        
    }

    public function publishprojectstatusewaas(Request $request)
    {
        $project_id  = $request->projectId;
        $user_id = Auth::id();
        $obj = DB::table('users')->where('id', $user_id)->first();
        if($obj) {
            
                $data = $this->sendMailTempPublishEwaas($obj,$project_id);
                if($data['status'] = 'success') {
                   
                    return ['status'=>true, 'msg'=>'OTP has been sent successfully. '];
                    
                } else if($data['status'] = 'false') {
                    return ['status'=>false, 'msg'=>'Error '];
                }
            
        } else {
            return redirect('forgot')->with('error', 'Incorrect details.');
        }

    }
    private function sendMailTempPublishEwaas($obj,$project_id)
    {
        $user_id = $obj->name;
        $to_email = $obj->email;
        $otp = mt_rand(1000, 9999);
        $data = array('user_id' => $user_id, 'email' => $to_email,'body' => $otp);
        
            Mail::send('mail.temppublishotpewaas', $data, function($message)use($data)
            {
                $message->to($data["email"], $data["user_id"])
                ->subject("Ernet");
            });

            if (Mail::flushMacros())
            {
                return array('status' => 'false', 'message' => 'Mail not send');
            }
            else
            {       
                DB::table('users')->where('id', $obj->id)->update(['ewaas_temp_publish_otp' => $otp,'ewaas_temp_publish_id' => $project_id]);
                return array('status' => 'success', 'message' => 'OTP has been sent successfully to your registered email id.Please check your email');
            }
    }
    public function verifypublishprojectewaas(Request $request)
    {
        return view('user.pages/verifyotppublishewaas');
        
    }
    public function publishprojectewaas(Request $request)
    {
        $params = $request->all();
        $messages = [
            'otp.required' => 'Please enter otp.'
        ];
        $rules = ['otp' =>'required'];
        $validator = validator()->make($params, $rules, $messages);
        if ($validator->fails())
        {
            return Redirect::back()->withErrors($validator->errors());
        }
        
        $user_id = Auth::id();
        $obj = DB::table('users')->where('id', $user_id)->first();

        if($obj->ewaas_temp_publish_otp != $request->otp) {
            return redirect('verifypublishprojectewaas')->with('error', 'Invalid OTP, Kindly, enter correct OTP');
        }else
        {
            
            $project_id  = $obj->ewaas_temp_publish_id;
                if ($project_id != null){
                    try {


                        $delete_template_data = DB::table('projects')->where('id','!=',$project_id)->where('vas_type','=','ewaas')->where('user_id','=',$user_id)->first();
                      
                        if($delete_template_data !=null){
                        $path = $delete_template_data->project_name;
                        $delete_project_id = $delete_template_data->id;
                        
                        $file_status = File::exists('/opt/bitnami/apache/htdocs/drupal/'.$path);//Storage::disk('drupal')->path($path));
                        if ($file_status) {
                            ini_set('max_execution_time', 1024);
                            $status = File::deleteDirectory('/opt/bitnami/apache/htdocs/drupal/'.$path);//Storage::disk('drupal')->path($path));
                        }
                        $databaseName = $delete_template_data->db_name;
                        $status = DB::statement("DROP DATABASE $databaseName");
                        DB::table('projects')->where('id','=',$delete_project_id)->delete();
                        }

                        
                        $pro = DB::table('projects')->where('id','=',$project_id)->where('vas_type','=','ewaas')->first();
                        $old_project_name = '/opt/bitnami/apache/htdocs/drupal/'.$pro->project_name;
                        $new_project_name = '/opt/bitnami/apache/htdocs/drupal/'.$obj->domainName;
                        DB::table('projects')->where('user_id', $obj->id)
                                             ->where('id', $project_id)
                                             ->where('vas_type','=','ewaas')
                                             ->update(['old_project_name' => $pro->project_name,'project_name' => $obj->domainName,'status'=> '1']);
                        $status = DB::table('users')->where('id', $obj->id)->update([
                                    'ewaas_temp_publish_otp' => null,
                                    'ewaas_temp_publish_status'=>1,
                                ]);
                        rename( $old_project_name, $new_project_name);
                        return redirect('projects')->with('success', 'Template Published Successfully.');
                        Session::flash('message','Template Published Successfully..');
                        Session::flash('alert-class', 'alert-success');

                        

                        }catch (Throwable $e) {
                        return redirect('projects')->with('error', 'Something went wrong');
                        
                    }
                }

        }
        
    }

    public function unpublishprojectstatusewaas(Request $request)
    {
        $project_id  = $request->projectId;
        $user_id = Auth::id();
        $obj = DB::table('users')->where('id', $user_id)->first();
        if($obj) {
            
                $data = $this->sendMailTempUnpublishEwaas($obj,$project_id);
                if($data['status'] = 'success') {
                   
                    return ['status'=>true, 'msg'=>'OTP has been sent successfully. '];
                    
                } else if($data['status'] = 'false') {
                    return ['status'=>false, 'msg'=>'Error '];
                }
            
        } else {
            return redirect('forgot')->with('error', 'Incorrect details.');
        }

    }

    private function sendMailTempUnpublishEwaas($obj,$project_id)
    {
        $user_id = $obj->name;
        $to_email = $obj->email;
        $otp = mt_rand(1000, 9999);
        $data = array('user_id' => $user_id, 'email' => $to_email,'body' => $otp);
        
            Mail::send('mail.tempunpublishotpewaas', $data, function($message)use($data)
            {
                $message->to($data["email"], $data["user_id"])
                ->subject("Ernet");
            });

            if (Mail::flushMacros())
            {
                return array('status' => 'false', 'message' => 'Mail not send');
            }
            else
            {       
                DB::table('users')->where('id', $obj->id)->update(['ewaas_temp_unpublish_otp' => $otp,'ewaas_temp_unpublish_id' => $project_id,'ewaas_temp_publish_id' => null]);
                return array('status' => 'success', 'message' => 'OTP has been sent successfully to your registered email id.Please check your email');
            }
    }

    public function useraccesstokenupdate()
    {
        $sessionToken = Str::random(32); 
        Session::put('auth_active_token', $sessionToken);
        $storetoken=DB::table('users')->where('id',Auth::user()->id)->update(['active_session_token'=>$sessionToken]);
        
        return array('status' => 'success', 'message' => 'success');
    }
    
    public function getTransInfo(Request $request,$id){

        $data=DB::table('payment_gateway_setting')->where('id',2)->first();

        $mid = $data->merchant_id;
        $secretKey = $data->checksum_key;
        $clientId = $data->security_id;

        $payloadData = [
            "mercid" => $mid,
            "orderid" =>$id ,
        ];
                
        $traceid = uniqid();
        $currentTimestamp = time();

        $headers = ["alg" => "HS256", "clientid" => $clientId, "kid" => "HMAC"];

         $curl_payload = JWT::encode($payloadData, $secretKey, "HS256", null ,$headers);

        $apiurl="https://api.billdesk.com/payments/ve1_2/transactions/get";

        $curl = curl_init($apiurl);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, [
            'Content-Type: application/jose', 
            'Accept: application/jose', 
            'BD-Traceid: ' . $traceid, 
            'BD-Timestamp: ' . $currentTimestamp,
        ]);
         
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $curl_payload);
         
        $result = curl_exec($curl);
        
        curl_close($curl);

        $encodedString = $result;
   
        $decoded = JWT::decode($encodedString, new Key($secretKey, 'HS256'));

        dd($decoded);

    }

    private function removeSpecialCharacters($string) {
      $cleanedString = preg_replace('/[^a-zA-Z0-9 \s]/', '', $string);

        $limitedString = substr($cleanedString, 0, 95);

        return $limitedString;

    }
    
    public function createBilldeskOrder(Request $request){
         
        $data=DB::table('payment_gateway_setting')->where('id',2)->first();


        $secretKey = $data->checksum_key;
        $clientId = $data->security_id;
         
        $mid = $data->merchant_id;
                
        $apiurl = Config::get('custom-billdesk.apiurl');
         
        $logo = Config::get('custom-billdesk.logo');

        $responseurl= Config::get('custom-billdesk.responseurl');
         
        $sdkPrimaryColor= Config::get('custom-billdesk.sdkPrimaryColor');
        $sdkAccentColor= Config::get('custom-billdesk.sdkAccentColor');
        $sdkBackgroundColor= Config::get('custom-billdesk.sdkBackgroundColor');
        $sdkBannerColor= Config::get('custom-billdesk.sdkBannerColor');

        $headers = ["alg" => "HS256", "clientid" => $clientId, "kid" => "HMAC"];

        $user=Auth::user();

        $uniqueid=genTransID($user->id);
        $ip=$request->ip();

        $period=$request->period??0;

        $namserver='';
        $dnssec='no';
        $dnssec_data='';

        if($request->transaction_type=='domainRegisterWithNameServer' || $request->transaction_type=='domainRegister' || $request->transaction_type=='nameServerUpdate' || $request->transaction_type=='userNameServerUpdate'){
            $namserver=json_encode(Session::get('data'));
        }

        if(Session::has('dnsse_data')){
            
            $dnssec='yes';
            $dnssec_data=json_encode(Session::get('dnsse_data'));

        }

        $usercontact=DB::table('user_contact_details')->select('address','state','gst_no')->where('user_id',$user->id)->first();
        
        $address='Not Available';
        $state='Not Available';
        $gst_no='Not Available';
        $institute='Not Available';

        if($usercontact!=null){

            if($user->institute && $user->institute!=''){
                $institute=$this->removeSpecialCharacters($user->institute);
            }


            if($usercontact->state!=null && $usercontact->state!=''){
                $state=$this->removeSpecialCharacters($usercontact->state);
            }


            if($usercontact->gst_no!=null && $usercontact->gst_no!=''){
                $gst_no=$this->removeSpecialCharacters($usercontact->gst_no);
            }


        }

        $orderDate = date('Y-m-d\TH:i:sP'); 
        $payloadData = [
            "mercid" => $mid,
            "orderid" =>$uniqueid ,
            "amount" => $request->amount,
            "order_date" => $orderDate,
            "currency" => "356",
            "ru" =>$responseurl,
            "additional_info" => [
              "additional_info1" => $request->remark,
              "additional_info2" =>$user->domainPunycode,
              "additional_info3" =>$period,
              "additional_info4"=>$institute,
              "additional_info5"=>$address,
              "additional_info6"=>$state,
              "additional_info7"=>$gst_no,
            ],
            "itemcode" => "DIRECT",
            "device" => [
                "init_channel" => "internet",
                "ip" => $ip,
                "user_agent" => "Mozilla/5.0(WindowsNT10.0;WOW64;rv:51.0)Gecko/20100101 Firefox/51.0",
                "accept_header" => "text/html",
                "fingerprintid" => "61b12c18b5d0cf901be34a23ca64bb19",
                "browser_tz" => "-330",
                "browser_color_depth" => "32",
                "browser_java_enabled" => "false",
                "browser_screen_height" => "601",
                "browser_screen_width" => "657",
                "browser_language" => "en-US",
                "browser_javascript_enabled" => "true"
            ]
        ];    
        
                 
        $traceid = uniqid();
        $currentTimestamp = time();

     

        $curl_payload = JWT::encode($payloadData, $secretKey, "HS256", null ,$headers);

        $curl = curl_init($apiurl);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, [
            'Content-Type: application/jose', 
            'Accept: application/jose', 
            'BD-Traceid: ' . $traceid, 
            'BD-Timestamp: ' . $currentTimestamp,
        ]);
         
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $curl_payload);
         
        $result = curl_exec($curl);
        
        curl_close($curl);
        
        $encodedString = $result;
   
        $decoded = JWT::decode($encodedString, new Key($secretKey, 'HS256'));

        $launch_billdesk = false;

        if($decoded->status=='ACTIVE'){

            $otoken=$decoded->links[1]->headers->authorization;

            $params=[
                'unique_id'=>$traceid,
                'reference_id'=>$uniqueid,
                'transaction_type'=>$request->transaction_type,
                'request_payload'=>json_encode($payloadData),
                'request'=>json_encode($request->all()),
                'response_payload'=>json_encode($decoded),
                'total_amount'=>$request->amount,
                'user_id'=>Auth::user()->id,
                'period'=>$period,
                'dns'=>$namserver,
                'state_name'=>$usercontact->state??'NA',
                'domain'=>$user->domainPunycode!=null?$user->domainPunycode:$user->domainName,
                'address'=>$usercontact->address??'NA',
                'org'=>$user->institute??'NA',
                'gst_no'=>$usercontact->gst_no??'NA',
                'created_at'=>date('Y-m-d H:i:s'),
                'dnssec'=>$dnssec,
                'dnssec_data'=>$dnssec_data
            ];
            $trans=DB::table('transactions')->insert($params);
            $launch_billdesk = true;

            return response()->json(array('status'=>'success', 'message' => 'Payment Started Successfully',
            'sdkPrimaryColor'=>$sdkPrimaryColor,'sdkAccentColor'=>$sdkAccentColor,'sdkBackgroundColor'=>$sdkBackgroundColor,'sdkBannerColor'=>$sdkBannerColor,
            'logo'=>$logo,'orderId'=>$decoded->bdorderid,'launch_billdesk'=>$launch_billdesk,'otoken'=>$otoken,'mid'=>$mid,'ru'=>$responseurl));

        }else{

            return response()->json(array('status'=>'error', 'message' => 'Billdesk Response Error','statusmsg'=>$decoded));

        }
       
        return response()->json(array('status'=>'error', 'message' => 'Can not Connect Billdesk'));

        }

    public function verifyunpublishprojectewaas(Request $request)
    {
        return view('user.pages/verifyotpunpublishewaas');
        
    }
    public function unpublishprojectewaas(Request $request)
    {
        $params = $request->all();
        $messages = [
            'otp.required' => 'Please enter otp.'
        ];
        $rules = ['otp' =>'required'];
        $validator = validator()->make($params, $rules, $messages);
        if ($validator->fails())
        {
            return Redirect::back()->withErrors($validator->errors());
        }
        
        $user_id = Auth::id();
        $obj = DB::table('users')->where('id', $user_id)->first();

        if($obj->ewaas_temp_unpublish_otp != $request->otp) {
            return redirect('verifyunpublishprojectewaas')->with('error', 'Invalid OTP, Kindly, enter correct OTP');
        }else
        {
            $project_id  = $obj->ewaas_temp_unpublish_id;
                if ($project_id != null){
                    try {
                        
                        $pro = DB::table('projects')->where('id','=',$project_id)->where('vas_type','=','ewaas')->first();
                        $project_name = '/opt/bitnami/apache/htdocs/drupal/'.$pro->project_name;
                        $old_project_name = '/opt/bitnami/apache/htdocs/drupal/'.$pro->old_project_name;
                        DB::table('projects')->where('user_id', $obj->id)
                                             ->where('id', $project_id)
                                             ->where('vas_type','=','ewaas')
                                             ->update(['old_project_name' => $pro->project_name,'project_name' =>$pro->old_project_name,'status'=> '0']);
                        $status = DB::table('users')->where('id', $obj->id)->update([
                                    'ewaas_temp_unpublish_otp' => null,
                                    'ewaas_temp_publish_status'=> '0'
                                ]);
                      
                        rename( $project_name,$old_project_name);
                        return redirect('projects')->with('success', 'Template Unpublished Successfully.');
                        Session::flash('message','Template Unpublished Successfully..');
                        Session::flash('alert-class', 'alert-success');

                        

                        }catch (Throwable $e) {
                        return redirect('projects')->with('error', 'Something went wrong');
                        
                    }
                }
        }
        
    }
}
