<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Mail\PasswordCreatedEmail;
use App\Mail\UserDomainEnquiryMail;
use App\Models\User;
use Carbon\Carbon;
use Redirect;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\File;
use mysqli;
use Illuminate\Support\Str;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\LoginHistory;
use phpseclib3\Net\SFTP;
use Firebase\JWT\JWT;
use Config;
use \Firebase\JWT\Key;
use Log;
use App\Library\EPP;
use App\Models\Zone;
use App\Services\Formatters\BINDFormatter;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Artisan;
use App\Models\Server;
use Throwable;


class MigrateController extends Controller
{
   
    const BASEDIR = 'probind';

    const CONFIG_BASEDIR = self::BASEDIR.DIRECTORY_SEPARATOR.'configuration';

    const ZONE_BASEDIR = self::BASEDIR.DIRECTORY_SEPARATOR.'primary';

    public function filetransfer(Request $request,$id){
       
        $limit = 3000;
        $offset = $id;
    
        $records=DB::table('testuser')->offset($offset)->limit($limit)->orderBy('id','asc')->get();
        
        foreach($records as $record){
       
        $documents=DB::table('testdocument')->where('ref_no',$record->ref_no)->get();
       
        foreach($documents as $doc){
       
       $sourcePath = public_path('user/docs');
       $destinationPath = public_path("user/docs/$record->id"); 
       
       $filename=$doc->filename;

       if($doc->filename!=null){
       
       try {
                 
       if (File::exists("$sourcePath/$doc->filename")) {
       
        if (!File::isDirectory($destinationPath)) {
         File::makeDirectory($destinationPath, 0775, true);
        }
       
       $stat=File::copy("$sourcePath/$doc->filename", "$destinationPath/$doc->filename");

       echo $stat;

        echo "<br>";
        }else{
           echo "$filename not found<br>";

        }



       } catch (\Exception $e) {
          echo "Error: " . $e->getMessage();
       }

       }
       
       }
       
       }
       
        echo "Completed";
       
   }

   public function pendingPaymentCheck(Request $request){

    $users = DB::table('users')
    ->whereIn('users.domainStatus', [1,2,3,4])
    ->where('created_at', '<', Carbon::now()->subDays(15))
    ->get();
     
    foreach ($users as $user){

        $pcount=DB::table('transactions')->where('user_id',$user->id)->where('transaction_status','0300')->count();

        if($pcount==0){

          try {   
         
            DB::table('deleted_users')->insert([
                'name'=>$user->name,
                'father_name'=>$user->father_name,
                'age'=>$user->age,
                'domainName'=>$user->domainName,
                'domainPunycode'=>$user->domainPunycode,
                'domainLangID'=>$user->domainLangID,
                'domainExtensionID'=>$user->domainExtensionID,
                'email'=>$user->email,
                'email_verified_at'=>$user->email_verified_at,
                'institute'=>$user->institute,
                'board'=>$user->board,
                'designation'=>$user->designation,
                'domainPeriod'=>$user->domainPeriod,
                'domainPrice'=>$user->domainPrice,
                'domainStatus'=>$user->domainStatus,
                'domainCreationDate'=>$user->domainCreationDate,
                'domainExpiryDate'=>$user->domainExpiryDate,
                'renew_years'=>$user->renew_years,
                'temp_status'=>0,
                'user_id'=>$user->id,
                'status'=>0,
                'is_active'=>2
            ]);

           DB::table('users')->where('id',$user->id)->delete();

          } catch (Throwable $e) {
              dd($e->getMessage());
          }


        }
        

    }

   }

   public function dataexportAbhi(Request $request){

    $host = '192.168.0.3';
    $username = 'root';
    $password = 'y1BA8=KRFT@w3';
    $database = 'ernet';
    
    $dumpFilePath = '/var/www/html/bkup0202.sql';
    
    $command = "mysqldump -h 192.168.0.3 -u root -p'y1BA8=KRFT@w3' ernet > /var/www/html/bkup0202.sql";
    
    $returnVar = NULL;
    $output = NULL;
    
    try {
        exec($command, $output, $returnVar);
    
        echo "Command Output: " . implode("\n", $output) . "\n";
        echo "Exit Status: " . $returnVar . "\n";
    
        if ($returnVar === 0) {
            echo "Database exported successfully. File saved at: {$dumpFilePath}";
        } else {
            echo "Error exporting database. Check your credentials and permissions.";
        }
    } catch (Exception $e) {
        echo "Exception: " . $e->getMessage() . "\n";
    }


   }

   public function migratePayment(Request $request){

    $namservers=DB::table('user_name_servers')->where('server_type',1)->select('user_name_servers.id','user_name_servers.user_id')->join('users','users.id','user_name_servers.user_id')->get();

    foreach($namservers as $namserver){

        $user=DB::table('transactions')->where('transaction_type','nameServerUpdate')->where('user_id',$namserver->user_id)->latest('id')->first();
        if($user!=null){
            $update=DB::table('user_name_servers')->where('id',$namserver->id)->update(['ernet_name_server_duration_year'=>$user->duration!=null?$user->duration:0]);
        }

    }

   }


   public function checkName(Request $request){

    $user_id = 169561;

    $users = DB::table('users')->where('id',$user_id)->first();
    $transactions = DB::table('transactions')->where('user_id',$users->id)->where('transaction_status','0300')->orderBy('id', 'DESC')->limit(1)->get();
    $user_detail = DB::table('user_contact_details')->where('user_id',$user_id)->first();
    $data2 = DB::table('transactions')->where('user_id',$user_id)->latest('id')->first();

    view()->share('data', $data2);
    view()->share('user', $users);
    view()->share('transactions', $transactions);
    view()->share('user_detail', $user_detail);

    $view_path = 'inv';
    $downloadname = 'invoice';
    
    $titlefromadmin=getmisc();
    $data['content'] = 'Sharing invoice for ('.$users->domainName .')';
    $data['email'] = $users->email;
    $data['extradata']='';
    $data['name'] = $users->name;
    $data['title'] = 'Sharing invoice for ('.$users->domainName .')';
    $pdf_name='invoice.pdf';
    $data['link']='';

    $pdf = Pdf::loadView('document.inv');

    return $pdf->stream();


    // $users = DB::table('users')
    // ->whereIn('users.domainStatus', [1,2,3,4])
    // ->where('created_at', '<', Carbon::now()->subDays(14))
    // ->whereIn('document_status',[0,2])
    // ->get();

    // $totalcount=0;

    // foreach ($users as $user){

    //     $pcount=DB::table('transactions')->where('user_id',$user->id)->where('transaction_status','0300')->count();

    //     if($pcount==0){
    //         $totalcount++;
    //         echo $user->domainName.'_'.$user->domainStatus;
    //         echo "<br>";

    //         $deleted=DB::table('users')->where('id',$user->id)->delete();
            
    //     }


    // }

    // echo "total ".$totalcount;

    // $epp=new EPP();

    // $paramscreate=[
    //     'ns1'=>[
    //         'host'=>'ns1.ernet.in',
    //         'ip4'=>null,
    //         'ip6'=>null,
    //     ],
    //     'ns2'=>[
    //         'host'=>'dns3.ernet.in',
    //         'ip4'=>null,
    //         'ip6'=>null,
    //     ],
    //     'ns3'=>[
    //         'host'=>'ns2.ernet.in',
    //         'ip4'=>null,
    //         'ip6'=>null,
    //     ],
    // ];
  
    //  $respone=$epp->domainaddNameServer('samaritansschoolgvp.edu.in',$paramscreate);

    //  dd($respone);

    // dd('completed');

   }

   public function checkTransaction(Request $request){

   $trans = DB::table('transactions')
   ->where('transaction_id','YHD41698977081')->first();

   $updated_date = date('Y-m-d H:i:s');
   $user = User::find($trans->user_id);

   $update = DB::table('user_documents')
   ->where('user_id','=', $trans->user_id)
   ->update(['status'=>1]);

   $domainPrice = $trans->total_amount;
   $user->domainPrice = $domainPrice;
   $user->domainStatus = 10;

    $user->renew_years = 6;
   
   $user->updated_at = $updated_date;
   $user->save();

   $update=DB::table('transactions')->where('id',$trans->id)->update(['period'=>6]);
   

   foreach ($users as $user){
   
       $data=DB::table('payment_gateway_setting')->where('id',2)->first();

       $mid = $data->merchant_id;
       $secretKey = $data->checksum_key;
       $clientId = $data->security_id;

       $payloadData = [
           "mercid" => $mid,
           "orderid" =>$user->reference_id ,
       ];
               
       $traceid = uniqid();
       $currentTimestamp = time();

       $headers = ["alg" => "HS256", "clientid" => $clientId, "kid" => "HMAC"];

        $curl_payload = JWT::encode($payloadData, $secretKey, "HS256", null ,$headers);

       $apiurl="https://api.billdesk.com/payments/ve1_2/transactions/get";

       $curl = curl_init($apiurl);
       curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
       curl_setopt($curl, CURLOPT_HTTPHEADER, [
           'Content-Type: application/jose', 
           'Accept: application/jose', 
           'BD-Traceid: ' . $traceid, 
           'BD-Timestamp: ' . $currentTimestamp,
       ]);
        
       curl_setopt($curl, CURLOPT_POST, true);
       curl_setopt($curl, CURLOPT_POSTFIELDS, $curl_payload);
        
       $result = curl_exec($curl);
       
       curl_close($curl);

       $encodedString = $result;
  
       $decodedresponse = JWT::decode($encodedString, new Key($secretKey, 'HS256'));


       try{
     

       if ($decodedresponse->auth_status=='0300'){

           $trans=DB::table('transactions')->where('reference_id',$decodedresponse->orderid)->where('transaction_status','0002')->first();
           
           $status=false;

           if($trans!=null){

               $payment_type = $trans->transaction_type;
               $user_id=$trans->user_id;
   
               $status=DB::table('transactions')->where('reference_id','=',$decodedresponse->orderid)->update(
                   [
                       'transaction_status'=>'0300',
                       'transaction_id'=>$decodedresponse->transactionid,
                       'response'=>json_encode($decodedresponse),
                       'response_format'=>'cron'
                   ]
               );
   
           }

         
           if($status){

               if ($payment_type == 'domainRegister'){
                   $updated_date = date('Y-m-d H:i:s');
                   $user = User::find($user_id);
                   $user->domainStatus = 3;
                   $user->updated_at = $updated_date;
                   $user->save();
   
                   if($trans->dns!='' && $trans->dns!=null){

                       $nameserver=json_decode($trans->dns,true);
   
                       DB::table('user_name_servers')
                           ->updateOrInsert(
                           ['user_id' => $user_id],
                           $nameserver
                       );

                   }
                  
   
                   if(Session::get('dnsse_data')!=null){
   
                       $dns_id = DB::table('user_name_servers')->where('user_id','=', $user_id)->first()->id;
                       DB::table('dns_security-extension')->where('user_dns_server_id','=',$dns_id)->delete();
                       
                       foreach (Session::get('dnsse_data') as $dnssec){
                           $dnssec['user_dns_server_id'] = $dns_id;
                           DB::table('dns_security-extension')->insert($dnssec);
                       }
   
                   }
                   

               }elseif ($payment_type == 'domainRegisterWithNameServer'){
                   
                   $nameserver=json_decode($trans->dns);
                   
                   DB::table('user_name_servers')
                       ->updateOrInsert(
                           ['user_id' => $user_id],
                           [
                                 "user_id" => $user_id,
                                 "server_type" => $nameserver->server_type??1,
                                 "primary_name_server" => $nameserver->primary_name_server??'',
                                 "secondary_name_server1" => $nameserver->secondary_name_server1??'',
                                 "secondary_name_server2" => $nameserver->secondary_name_server2??'',
                                 "secondary_name_server3" => $nameserver->secondary_name_server3??'',
                                 "secondary_name_server4" => $nameserver->secondary_name_server4??'',
                                 "secondary_name_server5" => $nameserver->secondary_name_server5??'',
                                 "ernet_name_server_duration_year" => $nameserver->ernet_name_server_duration_year??1,
                           ]
   
                       );
       
                   $updated_date = date('Y-m-d H:i:s');
                   $user = User::find($user_id);
                   $user->domainStatus = 3;
                   $user->updated_at = $updated_date;
                   $user->save();
   
              
               }elseif ($payment_type == 'nameServerUpdate'){
                   $nameserver1=json_decode($trans->dns);
                   
                   DB::table('user_name_servers')
                       ->updateOrInsert(
                           ['user_id' => $user_id],
                           [
                                 "user_id" => $user_id,
                                 "server_type" => $nameserver1->server_type??1,
                                 "primary_name_server" => $nameserver1->primary_name_server??'',
                                 "secondary_name_server1" => $nameserver1->secondary_name_server1??'',
                                 "secondary_name_server2" => $nameserver1->secondary_name_server2??'',
                                 "secondary_name_server3" => $nameserver1->secondary_name_server3??'',
                                 "secondary_name_server4" => $nameserver1->secondary_name_server4??'',
                                 "secondary_name_server5" => $nameserver1->secondary_name_server5??'',
                                 "ernet_name_server_duration_year" => $nameserver1->ernet_name_server_duration_year??1,
                           ]
                       );
   
                       $namserver=DB::table('user_name_servers')->where('user_id',$user_id)->first();
   
                       if($namserver!=null){
                           
                       $savedns=[
                           $namserver->primary_name_server,
                           $namserver->secondary_name_server1,
                       ];
                   
                       $paramscreate=[
                           'ns1'=>[
                               'host'=>$namserver->primary_name_server,
                               'ip4'=>$namserver->primary_name_server_ip,
                               'ip6'=>$namserver->primary_name_server_ip6,
                           ],
                           'ns2'=>[
                               'host'=>$namserver->secondary_name_server1,
                               'ip4'=>$namserver->secondary_name_server1_ip,
                               'ip6'=>$namserver->secondary_name_server1_ip6,
                           ],
                       ];
                   
                       if($namserver->secondary_name_server2!=null){
                           $paramscreate['ns3']=[
                               'host'=>$namserver->secondary_name_server2,
                               'ip4'=>$namserver->secondary_name_server2_ip,
                               'ip6'=>$namserver->secondary_name_server2_ip6,
                           ];
                           array_push($savedns,$namserver->secondary_name_server2);
                       }
                   
                       if($namserver->secondary_name_server3!=null){
                           $paramscreate['ns4']=[
                               'host'=>$namserver->secondary_name_server3,
                               'ip4'=>$namserver->secondary_name_server3_ip,
                               'ip6'=>$namserver->secondary_name_server3_ip6,
                           ];
                           array_push($savedns,$namserver->secondary_name_server3);
                       }
                   
                       if($namserver->secondary_name_server4!=null){
                           $paramscreate['ns5']=[
                               'host'=>$namserver->secondary_name_server4,
                               'ip4'=>$namserver->secondary_name_server4_ip,
                               'ip6'=>$namserver->secondary_name_server4_ip6,
                           ];
                           array_push($savedns,$namserver->secondary_name_server4);
                       }
                   
                       if($namserver->secondary_name_server5!=null){
                           $paramscreate['ns6']=[
                               'host'=>$namserver->secondary_name_server5,
                               'ip4'=>$namserver->secondary_name_server5_ip,
                               'ip6'=>$namserver->secondary_name_server5_ip6,
                           ];
                           array_push($savedns,$namserver->secondary_name_server5);
                       }
   
                   
                       $epp=new EPP();
                   
                       $user = DB::table('users')->where('id',$user_id)->first();
                   
                       $respone=$epp->domainInfo($user->domainName);
                   
                       $xml = new \SimpleXMLElement($respone);
                   
                       $xml->registerXPathNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                   
                       $nameservers = $xml->xpath('//domain:hostObj');
                   
                       $remNSD = array();
                       foreach ($nameservers as $nameserver) {
                        $remNSD[] = (string) $nameserver;
                       }
                       $res=$epp->domainupdateNameServerLatest($user->domainName,$paramscreate,$savedns,$remNSD);

                      
   
                       $updated_date = date('Y-m-d H:i:s');
   
                       $status = DB::table('zones')
                       ->updateOrInsert(
                           ['user_id' => $user_id],
                           [
                               'server'=>$namserver->primary_name_server,
                               'user_id' => $user_id,
                               'domain'=>$user->domainPunycode,
                               'reverse_zone'=>1,
                               'custom_settings'=>0,
                               'refresh'=>0,
                               'retry'=>7200,
                               'expire'=>3628800,
                               'negative_ttl'=>0,
                               'default_ttl'=>345640,
                               'updated_at'=>$updated_date
                           ]
                       );
   
                       $zone=Zone::where('domain',$user->domainPunycode)->first();
          
                       
   
                   }
                
               }elseif ($payment_type == 'userNameServerUpdate'){
                   
                   if($trans->dns!='' && $trans->dns!=null){

                       $nameserver=json_decode($trans->dns,true);
   
                       DB::table('user_name_servers')
                           ->updateOrInsert(
                           ['user_id' => $user_id],
                           $nameserver
                       );

                   }

                   $dns_record = DB::table('user_name_servers')->where('user_id','=', $user_id)->first();
   
                   $dns_id = $dns_record->id;
   
                   DB::table('dns_security-extension')->where('user_dns_server_id','=',$dns_id)->delete();
                   
                   if(Session::get('dnsse_data')!=null){
   
                       foreach (Session::get('dnsse_data') as $dnssec){
                           $dnssec['user_dns_server_id'] = $dns_id;
                           DB::table('dns_security-extension')->insert($dnssec);
                       }
   
                   }
   
                   $namserver=DB::table('user_name_servers')->where('user_id',$user_id)->first();
   
                   $savedns=[
                       $namserver->primary_name_server,
                       $namserver->secondary_name_server1,
                   ];
               
                   $paramscreate=[
                       'ns1'=>[
                           'host'=>$namserver->primary_name_server,
                           'ip4'=>$namserver->primary_name_server_ip,
                           'ip6'=>$namserver->primary_name_server_ip6,
                       ],
                       'ns2'=>[
                           'host'=>$namserver->secondary_name_server1,
                           'ip4'=>$namserver->secondary_name_server1_ip,
                           'ip6'=>$namserver->secondary_name_server1_ip6,
                       ],
                   ];
               
                   if($namserver->secondary_name_server2!=null){
                       $paramscreate['ns3']=[
                           'host'=>$namserver->secondary_name_server2,
                           'ip4'=>$namserver->secondary_name_server2_ip,
                           'ip6'=>$namserver->secondary_name_server2_ip6,
                       ];
                       array_push($savedns,$namserver->secondary_name_server2);
                   }
               
                   if($namserver->secondary_name_server3!=null){
                       $paramscreate['ns4']=[
                           'host'=>$namserver->secondary_name_server3,
                           'ip4'=>$namserver->secondary_name_server3_ip,
                           'ip6'=>$namserver->secondary_name_server3_ip6,
                       ];
                       array_push($savedns,$namserver->secondary_name_server3);
                   }
               
                   if($namserver->secondary_name_server4!=null){
                       $paramscreate['ns5']=[
                           'host'=>$namserver->secondary_name_server4,
                           'ip4'=>$namserver->secondary_name_server4_ip,
                           'ip6'=>$namserver->secondary_name_server4_ip6,
                       ];
                       array_push($savedns,$namserver->secondary_name_server4);
                   }
               
                   if($namserver->secondary_name_server5!=null){
                       $paramscreate['ns6']=[
                           'host'=>$namserver->secondary_name_server5,
                           'ip4'=>$namserver->secondary_name_server5_ip,
                           'ip6'=>$namserver->secondary_name_server5_ip6,
                       ];
                       array_push($savedns,$namserver->secondary_name_server5);
                   }
               
                   $epp=new EPP();
               
                   $user = DB::table('users')->where('id',$user_id)->first();
               
                   $respone=$epp->domainInfo($user->domainName);
               
                   $xml = new \SimpleXMLElement($respone);
   
                   $xmlElement = new \SimpleXMLElement($respone);
                   $xmlElement->registerXPathNamespace('secDNS', 'urn:ietf:params:xml:ns:secDNS-1.1');
               
                   $dsDataArray = [];
                   $dsDataElements = $xmlElement->xpath('//secDNS:dsData');
               
                   if($dsDataElements!=null){
                       foreach ($dsDataElements as $dsDataElement) {
                           $dsDataArray[] = [
                               'keyTag' => (string) $dsDataElement->children('secDNS', true)->keyTag,
                               'alg' => (string) $dsDataElement->children('secDNS', true)->alg,
                               'digestType' => (string) $dsDataElement->children('secDNS', true)->digestType,
                               'digest' => (string) $dsDataElement->children('secDNS', true)->digest
                           ];
                       }
                       $res=$epp->domainremDNSSEC($user->domainName,$dsDataArray);
                   }
               
                   $xml->registerXPathNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
               
                   $nameservers = $xml->xpath('//domain:hostObj');
               
                   $remNSD = array();
                   foreach ($nameservers as $nameserver) {
                    $remNSD[] = (string) $nameserver;
                   }
               
                 
                   $res=$epp->domainupdateNameServerLatest($user->domainName,$paramscreate,$savedns,$remNSD);
                   
                   $dsdtaas=DB::table('dns_security-extension')->where('user_dns_server_id',$namserver->id)->get();
   
                   $addDsData=[];
   
                   foreach ($dsdtaas as $name) {
                       if($name->key_tag!=null || $name->key_tag!=''){
                       $addDsData[] = [
                           'keyTag' => $name->key_tag,
                           'alg' => $name->algorithm,
                           'digestType' => $name->digest_type=='SHA1'?"1":'',
                           'digest' => $name->digest,
                       ];
                       }
                   }
   
                   $res=$epp->domainupdateDNSSEC($user->domainName,$addDsData);
   
                   $data['title'] = 'Name server of your domain ('.Auth::user()->domainName.') has been updated';
                   $data['email'] = Auth::user()->email;
                   $data['name'] = Auth::user()->name;
                   $data['domain'] = Auth::user()->domainName;
                   Mail::send('front.email.user-name-server-updated', $data, function($message)use($data) {
                       $message->to($data["email"], $data["name"])
                           ->subject($data["title"]);
                   });
   
               
   
                   if($dns_record->server_type==2){
   
                       $zone=Zone::where('domain',$user->domainPunycode)->first();
          
                       if($zone!=null){
                           $this->deletezone($zone);
                       }
   
                   }
   
               }elseif ($payment_type == 'domainRenewal'){
                   $updated_date = date('Y-m-d H:i:s');
                   $user = User::find($user_id);

                   $update = DB::table('user_documents')
                   ->where('user_id','=', $user_id)
                   ->update(['status'=>1]);

                   $domainPrice = $trans->total_amount;
                   $user->domainPrice = $domainPrice;
                   $user->domainStatus = 10;

                   if($user->renew_years==1){
                       $user->renew_years = $trans->period-1;
                   }else if($user->renew_years==2){
                       $user->renew_years = $trans->period-2;   
                   }else{
                       $user->renew_years = $trans->period;
                   }

                   $user->updated_at = $updated_date;
                   $user->save();
      
                   $user2 = User::find($user_id);

                   $epp=new EPP();
           
                   $expiryDate = Carbon::parse($user2->domainExpiryDate);
                   $currentDate = Carbon::now();
           
           if ($currentDate->diffInDays($expiryDate) >= 40) {
           
               $futureDate = $expiryDate->addDays(40);
           
               $orderDate = $futureDate->format('Y-m-d\TH:i:s\.0\Z');
           
               $currentDateTime = Carbon::now('Asia/Kolkata');
           
               $outputDateTime = $currentDateTime->format('Y-m-d\TH:i:s\.0\Z');
           
               $epp->domainRestoreRequest($user2->domainName);
           
               $epp->domainRestoreReport($user2->domainName,$orderDate,$outputDateTime);
           
               $epp->domainStatusUpdate($user2->domainName,'clientHold','add');

           }
                   
                   
               }else{

             
               }

           }else{

               
          
           }
          
       }else{
         
       }

       }catch(\Throwable $e){

         
       }

   }

   }


   public function holdManaualDomain(Request $request,$id){

    $user=User::find($id);
    $epp=new EPP();
    $epp->domainStatusUpdate($user->domainName,'clientHold','add');
    $update=User::where('id',$id)->update(['domainStatus'=>7]);

    dd('done');
    
   }

   public function migratePaymentRecords(Request $request){

   $records=DB::table('paymentleft')->get();

   foreach($records as $record){

    $trans=DB::table('transactions')->where('user_id',$record->user_id)->where('transaction_id',$record->transaction_id)->update(['created_at'=>$record->created_at,'updated_at'=>$record->created_at]);

   }

   dd('completed');

   }
   

public function migrateZoneRecord()
{
    $directoryPath = public_path('zones');

    $files = glob($directoryPath . '/*.csv');

    foreach ($files as $filePath) {
        $filename = pathinfo($filePath, PATHINFO_FILENAME);

        $this->migrateZoneFile($filePath,$filename);

    }
}



public function registerhardcopy(Request $request){


    try {
       
        
        $date='2024-01-08 00:00:00';

        $users = DB::table('users')
        ->where('domainStatus',5)
        // ->whereDate('users.domainCreationDate','>=',$date)
        ->get();


        foreach($users as $user){

            $update=DB::table('users')->where('id',$user->id)->update(['hard_copy'=>1]);

            // $details = [
            //     'user_id' => $user->id,
            //     'created_at' =>date('Y-m-d H:i:s',strtotime($user->updated_at)),
            //     'status' => 1
            // ];

            // $count=DB::table('domain_trails')
            // ->insert(
            //     $details
            // );            

            // if($count!=1){
            //     $update=DB::table('domain_trails')->where('id',$user->id)->delete();
            // }

            // $date=Carbon::parse($user->created_at)->format('Y-m-d H:i:s');
            // $update=DB::table('domain_trails')->where('id',$user->id)->update(['created_at'=>$date]);

        }

        dd('done');


    } catch (Throwable $e) {
            Log::info($e);
    }
    

}



public function incompleteList(Request $request){


    $users=DB::table('users')
          ->select('*')
          ->whereIn('users.domainStatus',[1,2,3,4])
        //   ->where('document_status','!=',1)
          ->get();

          

          $records=[];

          foreach($users as $i=> $user){


            $check=DB::table('transactions')->where('user_id',$user->id)->where('transaction_status','0300')
            ->whereDate('created_at', '<', '2024-01-08')
            ->count();

                $records[]=[
                    'S.No'=>++$i,
                    'Domain Name'=>$user->domainName,
                    'Date'=>$user->created_at,
                    'document_status'=>$user->document_status,
                    'Payment'=>$check
                ];

    

                }
             
    
    echo json_encode($records);

}


public function incompleteDeleteDomain(Request $request,$id){


    $user=User::find($id);


    DB::table('deleted_users')->insert([
        'name'=>$user->name,
        'father_name'=>$user->father_name,
        'age'=>$user->age,
        'domainName'=>$user->domainName,
        'domainPunycode'=>$user->domainPunycode,
        'domainLangID'=>$user->domainLangID,
        'domainExtensionID'=>$user->domainExtensionID,
        'email'=>$user->email,
        'email_verified_at'=>$user->email_verified_at,
        'institute'=>$user->institute,
        'board'=>$user->board,
        'designation'=>$user->designation,
        'domainPeriod'=>$user->domainPeriod,
        'domainPrice'=>$user->domainPrice,
        'domainStatus'=>$user->domainStatus,
        'domainCreationDate'=>$user->domainCreationDate,
        'domainExpiryDate'=>$user->domainExpiryDate,
        'renew_years'=>$user->renew_years,
        'temp_status'=>0,
        'user_id'=>$user->id,
        'status'=>1,
        'is_active'=>2,
    ]);

  
    DB::table('users')->where('id',$user->id)->delete();

    dd('done');

}

public function holdRemaindomains(Request $request){

    try {
        $users = DB::table('users')
            ->whereDate('domainExpiryDate','=',Carbon::now()->subDays(1)->format('Y-m-d'))
            ->where('domainStatus',6)->get();

        $data = [];

        $titlefromadmin=getmisc();

        foreach ($users as $user){
            $data['email'] = $user->email;
            $data['name'] = $user->name;
            $data['title'] = ' Your Domain ('.$user->domainName .') is on Hold';
            $data['hold_price'] = DB::table('misc_settings')->first()->reactivation_price;
            $data['content'] = $titlefromadmin->email_hold;
            $updated_date = date('Y-m-d H:i:s');
            $user = User::find($user->id);
            $user->domainStatus = 7;
            $user->updated_at = $updated_date;
            $user->save();

            $epp=new EPP();

            $epp->domainStatusUpdate($user->domainName,'clientHold','add');
            
            $data['ccMails']=getCCMail($user->id);

            try {

            Mail::send('front.email.domainOnHold', $data, function($message)use($data) {
                $message->to($data["email"], $data["name"])
                    ->cc($data["ccMails"])
                    ->subject($data["title"]);
            });

            } catch (Throwable $e) {
            Log::info($e);
            }

        }

    } catch (Throwable $e) {
        Log::info($e);
    }

}


public function informUsers(Request $request){

    $users = DB::table('users')->select('email','domainName','name','id')->where('domainStatus','>', 1)->where('domainName','iitk.ac.in')->get();

    foreach($users as $user){

        $data['email'] = $user->email;
        $data['name'] = $user->name!=null ? $user->name:'User';
        $data['title'] = ' Your Domain ('.$user->domainName .') password';
        $data['content'] = "test";

        $str = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ123456789';
        $shuffled = str_shuffle($str);
        $password = Str::substr($shuffled, 0, 8);
      
        $data['password'] = $password;

        $update=DB::table('users')->where('id',$user->id)->update(['password'=>$password]);

        Mail::send('front.email.informusers', $data, function($message)use($data) {
            $message->to($data["email"], $data["name"])
            ->subject($data["title"]);
        });

    }

}

    
    public function migrateZoneFile($filePath,$filename){
        
        if (!file_exists($filePath)) {
            Log::info('File not found: ' . $filePath);
            return;
        }

        $file = fopen($filePath, 'r');

        while (($line = fgets($file)) !== false) {
            $line = trim($line);

            if (empty($line)) {
                continue;
            }

            $recordData = $this->parseRecord($line,$filename);

            if ($recordData) {
                $this->insertRecord($recordData);
            }
        }

        fclose($file);

        Log::info('DNS records parsed and inserted successfully.');

    }

    private function insertRecord($data)
    {
        DB::table('user_name_server_records')
            ->insert(
                $data
            );

    }

    private function parseRecord($line,$filename)
    {
        $fields = explode("\t", $line); 
        
        $type=$fields[2]??'';

        if($type=='A' || $type=='MX' || $type=='NS' || $type=='CNAME' || $type=='TXT'){

            return $this->parseZoneRecord($fields,$filename);

        }
    }

    private function parseZoneRecord($fields,$filename)
    {

        $domain=DB::table('testuser')->where('domain',$filename)->first();

        $zone='';

        if($domain!=null){
            $zone=DB::table('zones')->select('id')->where('user_id',$domain->id)->first();
        }

            $name='';

            if(isset($fields[0])){
    
                if($fields[0]=='@'){
                    $name=trim($filename,'"');  
                }else{
                    $name=trim($fields[0],'"');    
                }
            }
    
            $data='';
    
            if(isset($fields[3])){
    
                if($fields[3]=='@'){
                    $data=trim($filename,'"');
                }else{
                    $data=trim($fields[3],'"');    
                }
            }
    
            return [
                'zone_id'=>$zone->id ??0,
                "user_id" => $domain->id??0,
                "type" => $fields[2]??'',
                "name" => $name,
                "data" => $data,
                "ttl" => 3600,
                "priority" => '',
                "weight" => '',
                "port" => '',
                "service" => '',
                "protocol" => '',
            ];

    }

    public function zonefilePush(Request $request,$id){

        $limit = 200;
        $offset = $id;
    
        $updatedZones=Zone::offset($offset)->limit($limit)->get();
        
        // $updatedZones=Zone::all();

        foreach ($updatedZones as $zone) {
            $this->generateZoneFile($zone);
        }
      
    }

    private function generateZoneFile(Zone $zone){
      
        $record=DB::table('users')->select('domainPunycode','domainName')->where('id',$zone->user_id)->first();

        $zone->increaseSerialNumber();
        $content = BINDFormatter::getZoneFileContent($zone);
        $filename = trim($record->domainName,'."');
        
        $file=$filename.'.hosts';

        // $path = self::ZONE_BASEDIR.DIRECTORY_SEPARATOR.$filename;
    
        
        try {        


            $destinationFileName1 = $file;

            $destinationServer1 = '202.141.18.89';
            $destinationUsername1 = 'root';
            $destinationPassword1 = '3rn3t@2023';
            $destinationFolder1 = '/var/named/zones';
            
            // $destinationServer1 = '202.41.64.252';
            // $destinationUsername1 = 'root';
            // $destinationPassword1 = 'y1BA8=W5@eK';
            // $destinationFolder1 = '/var/zones/primary';

            $sftp1 = new SFTP($destinationServer1,'22');

            if (!$sftp1->login($destinationUsername1, $destinationPassword1)) {
                throw new \Exception('SFTP login failed');
            }

            if (!$sftp1->chdir($destinationFolder1)) {
                throw new \Exception('Failed to change directory on the destination server');
            }

            if ($sftp1->file_exists($destinationFileName1)) {
                if (!$sftp1->delete($destinationFileName1)) {
                    throw new \Exception('Failed to delete the existing file on the destination server');
                }
            }

            
            if (!$sftp1->put($destinationFileName1, $content)) {
                throw new \Exception('Failed to transfer the file to the destination server');
            }

    
            $sftp1->disconnect();

        } catch (\Exception $e) {

            dd($e);

        }
       

    }

    
    private function zoneconfig(){

        $servers = Server::withPushCapability()->get();

        if (true === $servers->isEmpty()) {
            return true;
        }

        $pushedWithErrors = false;
        foreach ($servers as $i=> $server) {
           
            if (false === $this->handleServer($server) && (false === $pushedWithErrors)) {
                $pushedWithErrors = true;
            }
            
        }

        return ! $pushedWithErrors;

    }

    private function handleServer(Server $server): bool
    {
        $status=$this->generateConfigFileForServer($server);

        return true;

    }

    public function changedomainzone(Request $request){

        $zones=Zone::all();

        foreach($zones as $zone){

            $domain=DB::table('users')->select('domainName')->where('id',$zone->user_id)->first();
            
            if($domain){
            $update=Zone::where('id',$zone->id)->update(['domain'=>$domain->domainName]);
            }

        }

        echo 3;

    }

    public function domainnodns(Request $request,$id){

             
    $limit = 10000;
    $offset = $id;          

        $users=DB::table('users')->where('domainLangID',2)->offset($offset)->limit($limit)->get();

        $count=0;
        foreach($users as $user){


          $update=DB::table('users')->where('id',$user->id)->update(['domainPunycode'=>idn_to_ascii($user->domainName)]);


        }

 
        echo "done";

    }

    public function migrateAdmindetails(Request $request,$id){

             
        $limit = 5000;
        $offset = $id;          


        $year='2024';

        $users=DB::table('users')->select('domainName','id')
        ->whereYear('domainCreationDate','<',$year)
        ->offset($offset)->limit($limit)->get();

            $count=0;

            foreach($users as $user){
    
                $record=DB::table('user_contact_details')->where('user_id',$user->id)->first();

                if($record!=null){
                    

                    $admincontact=json_decode($record->administrative_detail,true);

                    $billing_contact_detail = [
                        'name' => $admincontact['name']??'',
                        'designation' => $admincontact['designation']??'',
                        'email' => $admincontact['email']??'',
                        'phone' => $admincontact['mobile']??'',
                        'prefix_phone'=>$admincontact['prefix_phone']??'',
                        'mobile' =>$admincontact['phone']??''
                    ];

                    $status = DB::table('user_contact_details')
                    ->updateOrInsert(
                        ['user_id' => $user->id],
                        ['administrative_detail' => json_encode($billing_contact_detail)]
                    );


                }
        
            }
    
     
            echo "final";
            echo $count;
            echo "<br>";
    
        }

    

    public function generateConfigFileForServer(Request $request)
    {
        $server=Server::first();

        $contents = BINDFormatter::getConfigurationFileContent($server);

        try {        

            $destinationFileName1 = 'zones.conf';

            $destinationServer1 = '202.141.18.89';
            $destinationUsername1 = 'root';
            $destinationPassword1 = '3rn3t@2023';
            $destinationFolder1 = '/var/named/zones';

            $sftp1 = new SFTP($destinationServer1,'22');

            if (!$sftp1->login($destinationUsername1, $destinationPassword1)) {
                throw new \Exception('SFTP login failed');
            }

            if (!$sftp1->chdir($destinationFolder1)) {
                throw new \Exception('Failed to change directory on the destination server');
            }

            if ($sftp1->file_exists($destinationFileName1)) {
                if (!$sftp1->delete($destinationFileName1)) {
                    throw new \Exception('Failed to transfer the file to the destination server');
                }
            }

            if (!$sftp1->put($destinationFileName1, $contents)) {
                throw new \Exception('Failed to transfer the file to the destination server');
            }

            $sftp1->disconnect();

        } catch (\Exception $e) {
            dd($e);
            
        }

    }

    public function createAutoZone(Request $request){

        $records = DB::table('user_name_servers')->select('users.domainPunycode','user_name_servers.user_id','user_name_servers.id','user_name_servers.primary_name_server')->where('user_name_servers.server_type', 1)->whereIn('users.domainStatus',[6,7,8,10])->join('users','users.id','user_name_servers.user_id')->get();

        foreach($records as $record){

                $status = DB::table('zones')
                ->updateOrInsert(
                    ['user_id' => $record->user_id],
                    [
                        'server'=>$record->primary_name_server,
                        'user_id' => $record->user_id,
                        'domain'=>$record->domainPunycode ?? '',
                        'reverse_zone'=>1,
                        'custom_settings'=>0,
                        'refresh'=>0,
                        'retry'=>7200,
                        'expire'=>3628800,
                        'negative_ttl'=>0,
                        'default_ttl'=>3600,
                        'updated_at'=>date('Y-m-d H:i:s')
                    ]
                );   

        }

    }

    public function migrateServer(Request $request,$id){
       
    $limit = 10000;
    $offset = $id;

    $records=DB::table('testserver')->offset($offset)->limit($limit)->orderBy('id','asc')->get();
          
        foreach($records as $record){

            if($record->name!=null && $record->user_id!=null){
                
            $checknameserver = DB::table('user_name_servers')->where('user_id','=', $record->user_id)->first();

            $params=[];

            if($record->server_type=='P'){
                $params['primary_name_server']=$record->name;
                $params['primary_name_server_ip']=$record->ipv4;
                $params['primary_name_server_ip6']=$record->ipv6;
            }else if($record->server_type=='S1'){
                $params['secondary_name_server1']=$record->name;
                $params['secondary_name_server1_ip']=$record->ipv4;
                $params['secondary_name_server1_ip']=$record->ipv6;
            }else if($record->server_type=='S2'){
                $params['secondary_name_server2']=$record->name;
                $params['secondary_name_server2_ip']=$record->ipv4;
                $params['secondary_name_server2_ip']=$record->ipv6;
            }else if($record->server_type=='S3'){
                $params['secondary_name_server3']=$record->name;
                $params['secondary_name_server3_ip']=$record->ipv4;
                $params['secondary_name_server3_ip']=$record->ipv6;
            }else if($record->server_type=='S4'){
                $params['secondary_name_server4']=$record->name;
                $params['secondary_name_server4_ip']=$record->ipv4;
                $params['secondary_name_server4_ip']=$record->ipv6;
            }else if($record->server_type=='S5'){
                $params['secondary_name_server5']=$record->name;
                $params['secondary_name_server5_ip']=$record->ipv4;
                $params['secondary_name_server5_ip']=$record->ipv6;
            }

            $servername=substr($record->name, -9);
            
            if($servername=='.ernet.in'){
                $params['server_type']=1;
            }else{
                $params['server_type']=2;
            }

            if($checknameserver!=null){

                $update = DB::table('user_name_servers')->where('user_id','=', $record->user_id)->update($params);

            }else{

                $params['user_id']=$record->user_id;
                $update = DB::table('user_name_servers')->insert($params);

            }
           
            }
       
        }
       
        echo "Completed";
       
    }

    public function migrateDocument(Request $request,$id){
       
        $limit = 3000;
        $offset = $id;

        $records=DB::table('testuser')->offset($offset)->limit($limit)->orderBy('id','asc')->get();
       
        foreach($records as $record){
       
        $documents=DB::table('testdocument')->where('ref_no',$record->ref_no)->whereIn('file_type',['AD','BD','RL'])->get();
       
        foreach($documents as $doc){

            if($doc->file_type=='AD' || $doc->file_type=='BD' || $doc->file_type=='RL'){


                $currentDateTime = Carbon::now();

                $daysago = $currentDateTime->subDays(30);

    
                $check=DB::table('users')->select('updated_at')->where('id',$record->id)->first();

                if($check){

                    $updatedAt = Carbon::parse($check->updated_at);

                    if ($updatedAt->year !== now()->year || $updatedAt->month !== now()->month) {
                        
                    
                $catid=0;

                if($doc->file_type=='AD'){
                    $catid=1;
                }else if($doc->file_type=='BD'){
                    $catid=2;
                }else if($doc->file_type=='RL'){
                    $catid=6;
                }

                $docstatus='';

                if($record->doc_status==1){
                    $docstatus=0;
                }else{
                    $docstatus=2;
                }

                $status = DB::table('user_documents')
                ->updateOrInsert(
                    ['user_id' => $record->id,'document_category_id' => $catid],
                    [
                        'user_id' => $record->id,
                        'document_category_id' => $catid,
                        'name' => $doc->filename,
                        'remarks' => '',
                        'path' => $doc->filename,
                        'upload_type'=>2, 
                        'status' => 2,
                    ]
                );

                }


                }

               

            }
       
          

            echo "completed";
       
       }
       
       }
       
        echo "Completed";
       
   }

   public function autologinDomain(Request $request,$id){

    $user=User::find($id);

    if (Auth::loginUsingId($id)) {
              
        $sessionToken = Str::random(32); 
        Session::put('auth_active_token', $sessionToken);
        $storetoken=DB::table('users')->where('id',Auth::user()->id)->update(['active_session_token'=>$sessionToken]);
        
        return redirect("user-dashboard");

    }

   }

   
   public function pendingApproved(Request $request){
       

    $records=DB::table('users')->select('id')->whereIn('domainStatus',[1,2,3,4])->get();
   
    foreach($records as $record){
   
    $documents=DB::table('user_documents')->where('user_id',$record->id)->update(['status'=>1]);
   
    }
   
    echo "Completed";
   
   }

   
   public function migrateStateCity(Request $request,$id){
    
    $limit = 3000;
    $offset = $id;

    $records=DB::table('user_contact_details')->offset($offset)->limit($limit)->orderBy('id','asc')->get();
 

    foreach($records as $record){
   
       $pincode=DB::table('cities')->select('regions.description as state','cities.name as city')->join('regions','regions.id','cities.region_id')->where('cities.pincode',$record->pincode)->first();

       $update=DB::table('user_contact_details')->where('user_id',$record->user_id)->update(['state'=>$pincode->state??'NA','city'=>$pincode->city??'NA']);

    }
       
    dd('done');

    
   }

   
   public function billdesksettle(Request $request){

    $users = DB::table('transactions')
    ->whereDate('created_at','=',Carbon::now()->subDays(4)->format('Y-m-d'))
    ->where('transaction_status','0002')->get();

    $titlefromadmin=getmisc();

    foreach ($users as $user){
    
        $data=DB::table('payment_gateway_setting')->where('id',2)->first();

        $mid = $data->merchant_id;
        $secretKey = $data->checksum_key;
        $clientId = $data->security_id;

        $payloadData = [
            "mercid" => $mid,
            "orderid" =>$user->reference_id ,
        ];
                
        $traceid = uniqid();
        $currentTimestamp = time();

        $headers = ["alg" => "HS256", "clientid" => $clientId, "kid" => "HMAC"];

         $curl_payload = JWT::encode($payloadData, $secretKey, "HS256", null ,$headers);

        $apiurl="https://api.billdesk.com/payments/ve1_2/transactions/get";

        $curl = curl_init($apiurl);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, [
            'Content-Type: application/jose', 
            'Accept: application/jose', 
            'BD-Traceid: ' . $traceid, 
            'BD-Timestamp: ' . $currentTimestamp,
        ]);
         
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $curl_payload);
         
        $result = curl_exec($curl);
        
        curl_close($curl);

        $encodedString = $result;
   
        $decodedresponse = JWT::decode($encodedString, new Key($secretKey, 'HS256'));


        try{
      
            echo $user->reference_id;
            echo "<br>";
            echo $decodedresponse->auth_status;

            echo "<br>";

        if ($decodedresponse->auth_status=='0300'){

            $trans=DB::table('transactions')->where('reference_id',$decodedresponse->orderid)->where('transaction_status','0002')->first();
            
            $status=false;

            if($trans!=null){

                $payment_type = $trans->transaction_type;
                $user_id=$trans->user_id;
    
                $status=DB::table('transactions')->where('reference_id','=',$decodedresponse->orderid)->update(
                    [
                        'transaction_status'=>'0300',
                        'transaction_id'=>$decodedresponse->transactionid,
                        'response'=>json_encode($decodedresponse)
                    ]
                );
    
            }

          
            if($status){

                if ($payment_type == 'domainRegister'){
                    $updated_date = date('Y-m-d H:i:s');
                    $user = User::find($user_id);
                    $user->domainStatus = 3;
                    $user->updated_at = $updated_date;
                    $user->save();
    
                    if($trans->dns!='' && $trans->dns!=null){

                        $nameserver=json_decode($trans->dns,true);
    
                        DB::table('user_name_servers')
                            ->updateOrInsert(
                            ['user_id' => $user_id],
                            $nameserver
                        );

                    }
                   
    
                    if(Session::get('dnsse_data')!=null){
    
                        $dns_id = DB::table('user_name_servers')->where('user_id','=', $user_id)->first()->id;
                        DB::table('dns_security-extension')->where('user_dns_server_id','=',$dns_id)->delete();
                        
                        foreach (Session::get('dnsse_data') as $dnssec){
                            $dnssec['user_dns_server_id'] = $dns_id;
                            DB::table('dns_security-extension')->insert($dnssec);
                        }
    
                    }
                    

                }elseif ($payment_type == 'domainRegisterWithNameServer'){
                    
                    $nameserver=json_decode($trans->dns);
                    
                    DB::table('user_name_servers')
                        ->updateOrInsert(
                            ['user_id' => $user_id],
                            [
                                  "user_id" => $user_id,
                                  "server_type" => $nameserver->server_type??1,
                                  "primary_name_server" => $nameserver->primary_name_server??'',
                                  "secondary_name_server1" => $nameserver->secondary_name_server1??'',
                                  "secondary_name_server2" => $nameserver->secondary_name_server2??'',
                                  "secondary_name_server3" => $nameserver->secondary_name_server3??'',
                                  "secondary_name_server4" => $nameserver->secondary_name_server4??'',
                                  "secondary_name_server5" => $nameserver->secondary_name_server5??'',
                                  "ernet_name_server_duration_year" => $nameserver->ernet_name_server_duration_year??1,
                            ]
    
                        );
        
                    $updated_date = date('Y-m-d H:i:s');
                    $user = User::find($user_id);
                    $user->domainStatus = 3;
                    $user->updated_at = $updated_date;
                    $user->save();
    
               
                }elseif ($payment_type == 'nameServerUpdate'){
                    $nameserver1=json_decode($trans->dns);
                    
                    DB::table('user_name_servers')
                        ->updateOrInsert(
                            ['user_id' => $user_id],
                            [
                                  "user_id" => $user_id,
                                  "server_type" => $nameserver1->server_type??1,
                                  "primary_name_server" => $nameserver1->primary_name_server??'',
                                  "secondary_name_server1" => $nameserver1->secondary_name_server1??'',
                                  "secondary_name_server2" => $nameserver1->secondary_name_server2??'',
                                  "secondary_name_server3" => $nameserver1->secondary_name_server3??'',
                                  "secondary_name_server4" => $nameserver1->secondary_name_server4??'',
                                  "secondary_name_server5" => $nameserver1->secondary_name_server5??'',
                                  "ernet_name_server_duration_year" => $nameserver1->ernet_name_server_duration_year??1,
                            ]
                        );
    
                        $namserver=DB::table('user_name_servers')->where('user_id',$user_id)->first();
    
                        if($namserver!=null){
                            
                        $savedns=[
                            $namserver->primary_name_server,
                            $namserver->secondary_name_server1,
                        ];
                    
                        $paramscreate=[
                            'ns1'=>[
                                'host'=>$namserver->primary_name_server,
                                'ip4'=>$namserver->primary_name_server_ip,
                                'ip6'=>$namserver->primary_name_server_ip6,
                            ],
                            'ns2'=>[
                                'host'=>$namserver->secondary_name_server1,
                                'ip4'=>$namserver->secondary_name_server1_ip,
                                'ip6'=>$namserver->secondary_name_server1_ip6,
                            ],
                        ];
                    
                        if($namserver->secondary_name_server2!=null){
                            $paramscreate['ns3']=[
                                'host'=>$namserver->secondary_name_server2,
                                'ip4'=>$namserver->secondary_name_server2_ip,
                                'ip6'=>$namserver->secondary_name_server2_ip6,
                            ];
                            array_push($savedns,$namserver->secondary_name_server2);
                        }
                    
                        if($namserver->secondary_name_server3!=null){
                            $paramscreate['ns4']=[
                                'host'=>$namserver->secondary_name_server3,
                                'ip4'=>$namserver->secondary_name_server3_ip,
                                'ip6'=>$namserver->secondary_name_server3_ip6,
                            ];
                            array_push($savedns,$namserver->secondary_name_server3);
                        }
                    
                        if($namserver->secondary_name_server4!=null){
                            $paramscreate['ns5']=[
                                'host'=>$namserver->secondary_name_server4,
                                'ip4'=>$namserver->secondary_name_server4_ip,
                                'ip6'=>$namserver->secondary_name_server4_ip6,
                            ];
                            array_push($savedns,$namserver->secondary_name_server4);
                        }
                    
                        if($namserver->secondary_name_server5!=null){
                            $paramscreate['ns6']=[
                                'host'=>$namserver->secondary_name_server5,
                                'ip4'=>$namserver->secondary_name_server5_ip,
                                'ip6'=>$namserver->secondary_name_server5_ip6,
                            ];
                            array_push($savedns,$namserver->secondary_name_server5);
                        }
    
                    
                        $epp=new EPP();
                    
                        $user = DB::table('users')->where('id',$user_id)->first();
                    
                        $respone=$epp->domainInfo($user->domainName);
                    
                        $xml = new \SimpleXMLElement($respone);
                    
                        $xml->registerXPathNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                    
                        $nameservers = $xml->xpath('//domain:hostObj');
                    
                        $remNSD = array();
                        foreach ($nameservers as $nameserver) {
                         $remNSD[] = (string) $nameserver;
                        }
                        $res=$epp->domainupdateNameServerLatest($user->domainName,$paramscreate,$savedns,$remNSD);

                       
    
                        $updated_date = date('Y-m-d H:i:s');
    
                        $status = DB::table('zones')
                        ->updateOrInsert(
                            ['user_id' => $user_id],
                            [
                                'server'=>$namserver->primary_name_server,
                                'user_id' => $user_id,
                                'domain'=>$user->domainPunycode,
                                'reverse_zone'=>1,
                                'custom_settings'=>0,
                                'refresh'=>0,
                                'retry'=>7200,
                                'expire'=>3628800,
                                'negative_ttl'=>0,
                                'default_ttl'=>345640,
                                'updated_at'=>$updated_date
                            ]
                        );
    
                        $zone=Zone::where('domain',$user->domainPunycode)->first();
           
                        
    
                    }
                 
                }elseif ($payment_type == 'userNameServerUpdate'){
                    
                    if($trans->dns!='' && $trans->dns!=null){

                        $nameserver=json_decode($trans->dns,true);
    
                        DB::table('user_name_servers')
                            ->updateOrInsert(
                            ['user_id' => $user_id],
                            $nameserver
                        );

                    }

                    $dns_record = DB::table('user_name_servers')->where('user_id','=', $user_id)->first();
    
                    $dns_id = $dns_record->id;
    
                    DB::table('dns_security-extension')->where('user_dns_server_id','=',$dns_id)->delete();
                    
                    if(Session::get('dnsse_data')!=null){
    
                        foreach (Session::get('dnsse_data') as $dnssec){
                            $dnssec['user_dns_server_id'] = $dns_id;
                            DB::table('dns_security-extension')->insert($dnssec);
                        }
    
                    }
    
                    $namserver=DB::table('user_name_servers')->where('user_id',$user_id)->first();
    
                    $savedns=[
                        $namserver->primary_name_server,
                        $namserver->secondary_name_server1,
                    ];
                
                    $paramscreate=[
                        'ns1'=>[
                            'host'=>$namserver->primary_name_server,
                            'ip4'=>$namserver->primary_name_server_ip,
                            'ip6'=>$namserver->primary_name_server_ip6,
                        ],
                        'ns2'=>[
                            'host'=>$namserver->secondary_name_server1,
                            'ip4'=>$namserver->secondary_name_server1_ip,
                            'ip6'=>$namserver->secondary_name_server1_ip6,
                        ],
                    ];
                
                    if($namserver->secondary_name_server2!=null){
                        $paramscreate['ns3']=[
                            'host'=>$namserver->secondary_name_server2,
                            'ip4'=>$namserver->secondary_name_server2_ip,
                            'ip6'=>$namserver->secondary_name_server2_ip6,
                        ];
                        array_push($savedns,$namserver->secondary_name_server2);
                    }
                
                    if($namserver->secondary_name_server3!=null){
                        $paramscreate['ns4']=[
                            'host'=>$namserver->secondary_name_server3,
                            'ip4'=>$namserver->secondary_name_server3_ip,
                            'ip6'=>$namserver->secondary_name_server3_ip6,
                        ];
                        array_push($savedns,$namserver->secondary_name_server3);
                    }
                
                    if($namserver->secondary_name_server4!=null){
                        $paramscreate['ns5']=[
                            'host'=>$namserver->secondary_name_server4,
                            'ip4'=>$namserver->secondary_name_server4_ip,
                            'ip6'=>$namserver->secondary_name_server4_ip6,
                        ];
                        array_push($savedns,$namserver->secondary_name_server4);
                    }
                
                    if($namserver->secondary_name_server5!=null){
                        $paramscreate['ns6']=[
                            'host'=>$namserver->secondary_name_server5,
                            'ip4'=>$namserver->secondary_name_server5_ip,
                            'ip6'=>$namserver->secondary_name_server5_ip6,
                        ];
                        array_push($savedns,$namserver->secondary_name_server5);
                    }
                
                    $epp=new EPP();
                
                    $user = DB::table('users')->where('id',$user_id)->first();
                
                    $respone=$epp->domainInfo($user->domainName);
                
                    $xml = new \SimpleXMLElement($respone);
    
                    $xmlElement = new \SimpleXMLElement($respone);
                    $xmlElement->registerXPathNamespace('secDNS', 'urn:ietf:params:xml:ns:secDNS-1.1');
                
                    $dsDataArray = [];
                    $dsDataElements = $xmlElement->xpath('//secDNS:dsData');
                
                    if($dsDataElements!=null){
                        foreach ($dsDataElements as $dsDataElement) {
                            $dsDataArray[] = [
                                'keyTag' => (string) $dsDataElement->children('secDNS', true)->keyTag,
                                'alg' => (string) $dsDataElement->children('secDNS', true)->alg,
                                'digestType' => (string) $dsDataElement->children('secDNS', true)->digestType,
                                'digest' => (string) $dsDataElement->children('secDNS', true)->digest
                            ];
                        }
                        $res=$epp->domainremDNSSEC($user->domainName,$dsDataArray);
                    }
                
                    $xml->registerXPathNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                
                    $nameservers = $xml->xpath('//domain:hostObj');
                
                    $remNSD = array();
                    foreach ($nameservers as $nameserver) {
                     $remNSD[] = (string) $nameserver;
                    }
                
                  
                    $res=$epp->domainupdateNameServerLatest($user->domainName,$paramscreate,$savedns,$remNSD);
                    
                    $dsdtaas=DB::table('dns_security-extension')->where('user_dns_server_id',$namserver->id)->get();
    
                    $addDsData=[];
    
                    foreach ($dsdtaas as $name) {
                        if($name->key_tag!=null || $name->key_tag!=''){
                        $addDsData[] = [
                            'keyTag' => $name->key_tag,
                            'alg' => $name->algorithm,
                            'digestType' => $name->digest_type=='SHA1'?"1":'',
                            'digest' => $name->digest,
                        ];
                        }
                    }
    
                    $res=$epp->domainupdateDNSSEC($user->domainName,$addDsData);
    
                    $data['title'] = 'Name server of your domain ('.Auth::user()->domainName.') has been updated';
                    $data['email'] = Auth::user()->email;
                    $data['name'] = Auth::user()->name;
                    $data['domain'] = Auth::user()->domainName;
                    Mail::send('front.email.user-name-server-updated', $data, function($message)use($data) {
                        $message->to($data["email"], $data["name"])
                            ->subject($data["title"]);
                    });
    
                
    
                    if($dns_record->server_type==2){
    
                        $zone=Zone::where('domain',$user->domainPunycode)->first();
           
                        if($zone!=null){
                            $this->deletezone($zone);
                        }
    
                    }
    
                }elseif ($payment_type == 'domainRenewal'){
                    $updated_date = date('Y-m-d H:i:s');
                    $user = User::find($user_id);

                    $domainPrice = $trans->total_amount;
                    $user->domainPrice = $domainPrice;
                    $user->domainStatus = 10;

                    if($user->renew_years==1){
                        $user->renew_years = $trans->period-1;
                    }else if($user->renew_years==2){
                        $user->renew_years = $trans->period-2;   
                    }else{
                        $user->renew_years = $trans->period;
                    }

                    $user->updated_at = $updated_date;
                    $user->save();
       
                    $user2 = User::find($user_id);

                    $epp=new EPP();
            
                    $expiryDate = Carbon::parse($user2->domainExpiryDate);
                    $currentDate = Carbon::now();
            
            if ($currentDate->diffInDays($expiryDate) >= 40) {
            
                $futureDate = $expiryDate->addDays(40);
            
                $orderDate = $futureDate->format('Y-m-d\TH:i:s\.0\Z');
            
                $currentDateTime = Carbon::now('Asia/Kolkata');
            
                $outputDateTime = $currentDateTime->format('Y-m-d\TH:i:s\.0\Z');
            
                $epp->domainRestoreRequest($user2->domainName);
            
                $epp->domainRestoreReport($user2->domainName,$orderDate,$outputDateTime);
            
                $epp->domainStatusUpdate($user2->domainName,'clientHold','add');

            }
                    
                    
                }else{

              
                }

            }else{

                
           
            }
           
        }else{
          
        }

        }catch(\Throwable $e){

          
        }
        
    
    }

   }
      
   public function domainDetailsInfo(Request $request,$id){


  $duplicates = DB::table('transactions')->select('transaction_type','transactions.user_id', DB::raw('COUNT(*) as count'),
  DB::raw('DATE(created_at) as date'), 
  )
  ->whereBetween('transactions.created_at', ['2023-04-01', '2024-03-18'])
  ->where('transactions.transaction_status','0300')
  ->where('transactions.transaction_type','=','userNameServerUpdate')
  ->groupBy(DB::raw('DATE(created_at)'), 'user_id','transaction_type')
  ->having('count', '>', 1)
  ->get();

    foreach($duplicates as $duplicate){

        $domain=DB::table('users')->select('domainName')->where('id',$duplicate->user_id)->first()->domainName??'';

        echo $domain;
        echo "   __date";
        echo $duplicate->date;
        echo "   __count";
        echo $duplicate->count;
        echo "   __type";
        echo $duplicate->transaction_type;
        echo "<br>";

    }

    
//     $user2 = User::find($id);

//     $epp = new EPP();
    
//     // $res = $epp->domainInfo($user->domainName);
//     // $res=$epp->deletedomain($user->domainName);

//     $expiryDate = Carbon::parse($user2->domainExpiryDate);
//     $currentDate = Carbon::now();

// // if ($currentDate->diffInDays($expiryDate) >= 40) {

// $futureDate = $expiryDate->addDays(40);

// $orderDate = $futureDate->format('Y-m-d\TH:i:s\.0\Z');

// $currentDateTime = Carbon::now('Asia/Kolkata');

// $outputDateTime = $currentDateTime->format('Y-m-d\TH:i:s\.0\Z');

// $res2=$epp->domainRestoreRequest($user2->domainName);

// dd($res2);

// $res=$epp->domainRestoreReport($user2->domainName,$orderDate,$outputDateTime);

// // $epp->domainStatusUpdate($user2->domainName,'clientHold','add');

// // }


//     // $epp->domainStatusUpdate($user->domainName,'clientHold','add');

//     dd($res);

    
//    }

//    public function contactInfo(Request $request,$id){
    

//     $epp = new EPP();
    
//     $res = $epp->contactInfo($id);

//     dd($res);
    

//    }

   
//    public function domainUpdateContact(Request $request,$id){


//     $user = User::find($id);
//     $usercontact=DB::table('user_contact_details')->select('*')->where('user_id',$user->id)->first();

//     $epp = new EPP();
    
//     $res = $epp->domainInfo($user->domainName);
        
    
//     $dom = new \DOMDocument();
//     $dom->loadXML($res);
    
//     $xpath = new \DOMXPath($dom);
//     $xpath->registerNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');

//     $contactsXml="";

//     $contents = [
//         'registrant',
//         'admin',
//         'tech',
//         'billing',
//     ];
    
//     foreach ($contents as $contactType) {

//         $org=$user->institute;
//         $name='';
//         $address=$usercontact->address;
//         $city=$usercontact->city;
//         $state=$usercontact->state;
//         $postcode=$usercontact->pincode;
//         $email='';
//         $mobileno='';

//         if($contactType=='registrant'){
//             $uniquecid=substr($user->domainName,0,5).'R'.rand(1999045,9934777);

//             $contactValue = $xpath->query('//domain:registrant');
    
//             $name=$user->name;
//             $email=$user->email;
//             $mobileno=$usercontact->mobile;
          
//         }else if($contactType=='admin'){
//             $uniquecid=substr($user->domainName,0,5).'A'.rand(1999045,9934777);

//             $contactValue = $xpath->query('//domain:contact[@type="admin"]');

           
//             $value=json_decode($usercontact->administrative_detail,true);

//             $name=$value['name']??'';
//             $email=$value['email']??'';
//             $mobileno=$value['mobile']??'';

//         }else if($contactType=='tech'){
//             $uniquecid=substr($user->domainName,0,5).'T'.rand(1999045,9934777);

//             $contactValue = $xpath->query('//domain:contact[@type="tech"]');

//             $value=json_decode($usercontact->technical_detail,true);

//             $name=$value['name']??'';
//             $email=$value['email']??'';
//             $mobileno=$value['mobile']??'';

//         }else if($contactType=='billing'){
//             $uniquecid=substr($user->domainName,0,5).'B'.rand(1999045,9934777);

//             $contactValue = $xpath->query('//domain:contact[@type="billing"]');

//             $value=json_decode($usercontact->billing_contact_detail,true);

//             $name=$value['name']??'';
//             $email=$value['email']??'';
//             $mobileno=$value['mobile']??'';

//         }

//         if ($contactValue->length > 0) {
//             $contactValue = $contactValue->item(0)->nodeValue;
//         }

//         $params=[
//             'name'=>$name,
//             'org'=>$this->removeSpecialCharacters($org),
//             'address'=>$this->removeSpecialCharacters($address),
//             'city'=>$this->removeSpecialCharacters($city),
//             'state'=>$this->removeSpecialCharacters($state),
//             'postcode'=>$postcode,
//             'country'=>'IN',
//             'mobile'=>'+91.'.$mobileno,
//             'email'=>$email,
//             'password'=>'Ernet@123'
//         ];
    
//         $test = $epp->contactTypeCreate($uniquecid,$params);            
//         $result = $epp->domainUpdateContact($user->domainName,$contactType,$uniquecid,$contactValue);

      
//     }

    
    dd('done');

   }

   private function removeSpecialCharacters($string) {
    $cleanedString = preg_replace('/[^a-zA-Z0-9- \s]/', '', $string);

    // $limitedString = substr($cleanedString, 0, 95);

    return $cleanedString;

}
   
   public function domainInfo(Request $request,$id){

    $user=User::where('id',$id)->first();

    $epp=new EPP();

    $res2=$epp->domainStatusUpdate($user->domainName,'clientHold','rem');

    dd($res2);

    // $dates='2024-01-18 18:59:00';

    // $params=[
    //     'domainExpiryDate'=>$dates,
    //     'updated_at'=>date('Y-m-d H:i:s'),
    //     'renew_years'=>1,
    // ];

    $expiryDate = Carbon::parse($user->domainExpiryDate);
    $currentDate = Carbon::now();

    $epp=new EPP();

$futureDate = $expiryDate->addDays(40);

$orderDate = $futureDate->format('Y-m-d\TH:i:s\.0\Z');

$currentDateTime = Carbon::now('Asia/Kolkata');

$outputDateTime = $currentDateTime->format('Y-m-d\TH:i:s\.0\Z');

$epp->domainRestoreRequest($user->domainName);

$res=$epp->domainRestoreReport($user->domainName,$orderDate,$outputDateTime);

dd($res);

    // $update=DB::table('users')->where('id',$user->id)->update($params);

    // $res2=$epp->domainStatusUpdate($id,'clientHold','rem');

    // $res=$epp->deletedomain($id);


    dd($res);
 

    dd($res);

    $user = User::find($id);
    
    $epp=new EPP();

    $res=$epp->domainStatusUpdate($user->domainName,'clientHold','rem');
    
    dd($res);

    $res = $epp->domainInfo($user->domainName);

    dd($res);
    $users = DB::table('users')
    ->whereIn('domainStatus',[0,1,2])
    ->whereRaw('DATEDIFF(CURRENT_DATE, created_at) > 8')
    ->get();


    foreach ($users as $user){

        $pcount=DB::table('transactions')->where('user_id',$user->id)->where('transaction_status','0300')->count();

        if($pcount==0){

        $data = [];
        $data['email'] = $user->email;
        $data['name'] = $user->name;
        $data['title'] = 'Your Domain ('.$user->domainName .') has been deleted';

        $data['content'] = 'Since you did not responded to our email and not submitted the application in timely manner. So, your domain has been deleted';
    
        echo $user->domainName;
        echo "<br>";

    try {   

        Mail::send('front.email.finalsubmissionpending', $data, function($message)use($data) {
            $message->to($data["email"], $data["name"])
                ->subject($data["title"])
                ->bcc('ernet.tejal@gmail.com');
        });

    } catch (Throwable $e) {
        Log::info($e);
    }

        DB::table('users')->where('id',$user->id)->delete();

        }
        

    }

    dd('done');

    $date=date('Y-m-d');
    $totalreg=DB::table('users')->whereDate('domainCreationDate',$date)->count();

    $totalrenew=DB::table('domain_trails')->whereDate('created_at',$date)->count();

    $totalpending=DB::table('users')->whereDate('applicationDate',$date)->count();

    $totalpayment=DB::table('transactions')->whereDate('created_at',$date)->where('transaction_status','0300')->sum('total_amount');
    
    $status = DB::table('daily_reports')
    ->updateOrInsert(
        ['date' => $date],
        [
            'registered' => $totalreg,
            'renew'=>$totalrenew,
            'pending_creation'=>$totalpending,
            'total_payment'=>$totalpayment
        ]
    );
    dd('done');

    $user = User::find($id);
    $epp = new EPP();
    
    $res = $epp->domainInfo($user->domainName);

    $val=ok_epp_xml2array($res);

    dd($val);
    
    $xml = simplexml_load_string($res);

    $resultAttributes = $xml->response->result->attributes();
    
    $resultMessage = (string) $xml->response->result->msg;
    
    $resData = $xml->response->resData->children('urn:ietf:params:xml:ns:domain-1.0');    
 
    $dataArray = [
        'result' => [
            'code' => (string) $resultAttributes['code'],
            'message' => $resultMessage
        ],
        'resData' =>$resData 
    ];
    
    // Convert the array to JSON
    $json = json_encode($dataArray);
    
    // Output for debugging
    dd($dataArray, $json);

    dd($xml);
    $json = $this->xmlToArray($xml);

    dd($json);

    dd(json_encode($json));


    $dom = new \DOMDocument();
    $dom->loadXML($res);
    
    $xpath = new \DOMXPath($dom);
    $xpath->registerNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
    
    $exDateElements = $xpath->query('//domain:exDate');
    
    if ($exDateElements->length > 0) {
        $exDateValue = $exDateElements->item(0)->nodeValue;
    
        $userExpiryDate = $user->domainExpiryDate;
    
        $formattedUserExpiryDate = $userExpiryDate->format('Y-m-d');
    
        if ($formattedUserExpiryDate > $exDateValue) {
            echo "User's domain has a later expiry date.\n";
            echo $formattedUserExpiryDate;
            echo $exDateValue;
        } elseif ($formattedUserExpiryDate < $exDateValue) {
            echo $formattedUserExpiryDate;
            echo $exDateValue;
            echo "User's domain has an earlier expiry date.\n";
        } else {
            echo $formattedUserExpiryDate;
            echo $exDateValue;
            echo "Both expiry dates are the same.\n";
        }
    }

   }

   private function xmlToArray($xml, $options = []){

    
    $defaults = [
        'namespaceRecursive' => false, // Get XML doc namespaces recursively
        'removeNamespace' => true, // Remove namespace from resulting keys
        'namespaceSeparator' => ':', // Change separator to something other than a colon
        'attributePrefix' => '', // Distinguish between attributes and nodes with the same name
        'alwaysArray' => [], // Array of XML tag names which should always become arrays
        'autoArray' => true, // Create arrays for tags which appear more than once
        'textContent' => 'text', // Key used for the text content of elements
        'autoText' => true, // Skip textContent key if node has no attributes or child nodes
        'keySearch' => false, // (Optional) search and replace on tag and attribute names
        'keyReplace' => false, // (Optional) replace values for above search values
    ];
    $options = array_merge($defaults, $options);
    $namespaces = $xml->getDocNamespaces($options['namespaceRecursive']);
    $namespaces[''] = null; // Add empty base namespace

    // Get attributes from all namespaces
    $attributesArray = [];
    foreach ($namespaces as $prefix => $namespace) {
        if ($options['removeNamespace']) {
            $prefix = '';
        }
        foreach ($xml->attributes($namespace) as $attributeName => $attribute) {
            // (Optional) replace characters in attribute name
            if ($options['keySearch']) {
                $attributeName = str_replace($options['keySearch'], $options['keyReplace'], $attributeName);
            }
            $attributeKey = $options['attributePrefix'] . ($prefix ? $prefix . $options['namespaceSeparator'] : '') . $attributeName;
            $attributesArray[$attributeKey] = (string) $attribute;
        }
    }

    // Get child nodes from all namespaces
    $tagsArray = [];
    foreach ($namespaces as $prefix => $namespace) {
        if ($options['removeNamespace']) {
            $prefix = '';
        }

        foreach ($xml->children($namespace) as $childXml) {
            // Recurse into child nodes
            $childArray = $this->xmlToArray($childXml, $options);
            $childTagName = key($childArray);
            $childProperties = current($childArray);

            // Replace characters in tag name
            if ($options['keySearch']) {
                $childTagName = str_replace($options['keySearch'], $options['keyReplace'], $childTagName);
            }

            // Add namespace prefix, if any
            if ($prefix) {
                $childTagName = $prefix . $options['namespaceSeparator'] . $childTagName;
            }

            if (!isset($tagsArray[$childTagName])) {
                // Only entry with this key
                // Test if tags of this type should always be arrays, no matter the element count
                $tagsArray[$childTagName] = in_array($childTagName, $options['alwaysArray'], true) || !$options['autoArray'] ? [$childProperties] : $childProperties;
            } elseif (is_array($tagsArray[$childTagName]) && array_keys($tagsArray[$childTagName]) === range(0, count($tagsArray[$childTagName]) - 1)) {
                // Key already exists and is integer indexed array
                $tagsArray[$childTagName][] = $childProperties;
            } else {
                // Key exists so convert to integer indexed array with previous value in position 0
                $tagsArray[$childTagName] = [$tagsArray[$childTagName], $childProperties];
            }
        }
    }

    // Get text content of node
    $textContentArray = [];
    $plainText = trim((string) $xml);
    if ($plainText !== '') {
        $textContentArray[$options['textContent']] = $plainText;
    }

    // Stick it all together
    $propertiesArray = !$options['autoText'] || $attributesArray || $tagsArray || $plainText === '' ? array_merge($attributesArray, $tagsArray, $textContentArray) : $plainText;

    // Return node as array
    return [
        $xml->getName() => $propertiesArray,
    ];

   }

   
   public function augSepAuto(Request $request){

    $users=DB::table('users')
          ->whereIn('domainStatus',[7,8])
          ->where('domainExpiryDate','>',Carbon::now()->format('Y-m-d H:i:s'))
          ->get();


    foreach($users as $user){

        $minusdate=Carbon::parse($user->domainExpiryDate)->subYears(1);

        $update=DB::table('users')->where('id',$user->id)->update(['domainExpiryDate'=>$minusdate,'renew_years'=>1]);

        echo $user->domainName.' '.$minusdate;
        echo "<br>";


    }

   }

   public function aprilAuto(Request $request){

    $users=DB::table('april')
          ->get();


    foreach($users as $user){


        $dom=DB::table('users')->where('domainName',$user->domain)->first();

        if($dom!=null){

            // echo $dom->domainName.' '.$dom->domainExpiryDate.' '.$dom->domainStatus;
            // echo '<br>';

        }else{

            
        $epp=new EPP();
        $domainNixi=$epp->domainInfo($user->domain);
     
        $eppjson=xmlConverter($domainNixi);
        
        $value=$eppjson['epp']['response'];
        if(isset($value['resData'])){

        $val=$value['resData']['domain:infData'];

        if(isset($val['domain:status_attr'])){
            $currentstatus=$val['domain:status_attr'];           
        }else{
            $currentstatus=$val['domain:status'];
        }

        if(isset($currentstatus['s']) || isset($currentstatus['0_attr']['s']) ){

            if(isset($currentstatus['0_attr']['s'])){
                $v=$currentstatus['0_attr']['s'];
            }else{
                $v=$currentstatus['s'];
            }

          if($v=='clientHold' ){

             $deluser = DB::table('deleted_users')
            ->where('domainName', $user->domain)->latest('id')->first();
        
            if($deluser==null){
        
                echo "User not found on dleetd";
        
            }else{
        
                
                $deluser=DB::table('deleted_users')->where('domainName',$user->domain)->latest('user_id')->first();

                $year=Carbon::parse($deluser->domainExpiryDate)->format('Y');

                
                if($year=='2023'){

                    $password = Hash::make('Ernet@123');
                                 
                    DB::table('users')->insert([
                                'id' =>$deluser->user_id,
                                'name'=>$deluser->name,
                                'father_name'=>$deluser->father_name,
                                'age'=>$deluser->age,
                                'domainName'=>$deluser->domainName,
                                'domainPunycode'=>idn_to_ascii($deluser->domainName),
                                'domainLangID'=>$deluser->domainLangID,
                                'domainExtensionID'=>$deluser->domainExtensionID,
                                'email'=>$deluser->email,
                                'email_verified_at'=>$deluser->email_verified_at,
                                'password'=>$password,
                                'institute'=>$deluser->institute,
                                'board'=>$deluser->board,
                                'designation'=>$deluser->designation,
                                'domainPeriod'=>$deluser->domainPeriod,
                                'domainPrice'=>$deluser->domainPrice,
                                'domainStatus'=>8,
                                'domainCreationDate'=>$deluser->domainCreationDate,
                                'domainExpiryDate'=>"2024-01-07 18:59:00",
                                'renew_years'=>1,
                                'document_status'=>0,
                                'status'=>1
                    ]);
            
            
                    $titlefromadmin=getmisc();
            
                    $expiry=date('d-m-Y',strtotime($deluser->domainExpiryDate));
            
                    $data['email'] = $deluser->email;
                    $data['name'] = $deluser->name;
                    $data['exp']=$expiry;
                    $data['title'] = 'Your Domain ('.$deluser->domainName .') is already expired and is in Restorable Period and domain was expired on'.$expiry;        
            
                    try {
            
                    Mail::send('admin.email.nixihold', $data, function($message)use($data) {
                        $message->to($data["email"], $data["name"])
                            ->subject($data["title"])
                            ->bcc('intileobackup@gmail.com','ernet.tejal@gmail.com');
                    });
            
                    } catch (Throwable $e) {
                      Log::info($e);
                    }
            
                    $epp->domainStatusUpdate($deluser->domainName,'clientHold','rem');

                    $res=$epp->deletedomain($deluser->domainName);

                    $del=DB::table('deleted_users')->where('user_id',$deluser->user_id)->delete();
            
                    $finalrem=DB::table('april')->where('id',$user->id)->delete();

                    echo 'dleete from april '.$user->domain;
                    echo "<br>";
                    echo 'User Restored';
    
                    echo "<br>";


                }else{

                    // echo "Domain was expired ".$deluser->domainName." ".$deluser->domainExpiryDate;
                    // echo "<br>";



                }
               

            }

          }
     
       }else{

        echo $user->domain;
        echo "no record found";
        echo "<br><br>";

        dd($currentstatus);
        
        }
            


        }


    }

   }

}

   


   public function deletetoPendingRestorable(Request $request,$id,$exp){

    $user = DB::table('deleted_users')
    ->where('user_id', $id)->first();

    if($user==null){

        dd('User Not Found');

    }else{

        $password = Hash::make('Ernet@123');
                 
        $delete=DB::table('users')->where('id',$user->user_id)->delete();

        DB::table('users')->insert([
                    'id' =>$user->user_id,
                    'name'=>$user->name,
                    'father_name'=>$user->father_name,
                    'age'=>$user->age,
                    'domainName'=>$user->domainName,
                    'domainPunycode'=>idn_to_ascii($user->domainName),
                    'domainLangID'=>$user->domainLangID,
                    'domainExtensionID'=>$user->domainExtensionID,
                    'email'=>$user->email,
                    'email_verified_at'=>$user->email_verified_at,
                    'password'=>$password,
                    'institute'=>$user->institute,
                    'board'=>$user->board,
                    'designation'=>$user->designation,
                    'domainPeriod'=>$user->domainPeriod,
                    'domainPrice'=>$user->domainPrice,
                    'domainStatus'=>8,
                    'domainCreationDate'=>$user->domainCreationDate,
                    'domainExpiryDate'=>$exp,
                    'renew_years'=>0,
                    'document_status'=>0,
                    'status'=>1
        ]);


        $titlefromadmin=getmisc();

        $expiry=date('d-m-Y',strtotime($user->domainExpiryDate));

        $data['email'] = $user->email;
        $data['name'] = $user->name;
        $data['title'] = 'Your Domain ('.$user->domainName .') is already expired and is in Restorable Period and domain was expired on'.$expiry;
        $data['hold_price'] = DB::table('misc_settings')->first()->hold_deduction_price;
        $data['content'] = $titlefromadmin->email_restorable;


        try {

            $epp=new EPP();
            

            $epp->domainStatusUpdate($user->domainName,'clientHold','add');

        Mail::send('front.email.domainTempDelete', $data, function($message)use($data) {
            $message->to($data["email"], $data["name"])
                ->subject($data["title"])
                ->bcc('anurag.gupta@intileo.com');
        });

         } catch (Throwable $e) {
          Log::info($e);
        }

        $del=DB::table('deleted_users')->where('user_id',$id)->delete();

            dd('User Restored');

    }


   }

//    public function eppPendingRestorable(Request $request,$id){

//     $user = DB::table('users')
//     ->where('id', $id)->first();

//     if($user==null){

//         dd('User Not Found');

//     }else{

       
//         dd($user->domainName);

//     }

//    }




   public function incompleteDelete(Request $request){

    
    $records=DB::table('users')->select('id','domainName')->whereIn('domainStatus',[1,2,3,4])
    ->where('updated_at', '<', Carbon::parse('2023-07-01'))
    ->get();
    $count=0;

    foreach($records as $record){
   
        $count++;
      

    }
       
    dd($count);

   }

public function DeletedUsersHold(Request $request, $id)
{
    $deletedusers = DB::table('deleted_users')
                    ->where('user_id', $id)->get();
                    #dd($deletedusers);
                    if($deletedusers!=null){
                            foreach ($deletedusers as $user){

                                $password = Hash::make('ernet@123');
                                        
                                                DB::table('users')->insert([
                                                            'id' =>$user->user_id,
                                                            'name'=>$user->name,
                                                            'father_name'=>$user->father_name,
                                                            'age'=>$user->age,
                                                            'domainName'=>$user->domainName,
                                                            'domainPunycode'=>$user->domainPunycode,
                                                            'domainLangID'=>$user->domainLangID,
                                                            'domainExtensionID'=>$user->domainExtensionID,
                                                            'email'=>$user->email,
                                                            'email_verified_at'=>$user->email_verified_at,
                                                            'password'=>$password,
                                                            'institute'=>$user->institute,
                                                            'board'=>$user->board,
                                                            'designation'=>$user->designation,
                                                            'domainPeriod'=>$user->domainPeriod,
                                                            'domainPrice'=>$user->domainPrice,
                                                            'domainStatus'=>$user->domainStatus,
                                                            'domainCreationDate'=>$user->domainCreationDate,
                                                            'domainExpiryDate'=>$user->domainExpiryDate,
                                                            'renew_years'=>0,
                                                            'document_status'=>0,
                                                            // 'domainStatus'=>7,
                                                            'status'=>1
                                                        ]);
                                    }      
                            
                            echo "Completed";
        }

}
   
}
