<?php

namespace App\Http\Controllers\user;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Rules\ImageMaliciousDetectionRule;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Models\EmailSetting;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
use Throwable;
use Validator;
use File;
use const http\Client\Curl\AUTH_ANY;
use App\Library\EPP;
use App\Models\Zone;
use App\Services\Formatters\BINDFormatter;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Hash;
use phpseclib3\Net\SFTP;
use App\Models\LoginHistory;
use Barryvdh\DomPDF\Facade\Pdf;

class UserController extends Controller
{
    const BASEDIR = 'probind';

    const CONFIG_BASEDIR = self::BASEDIR.DIRECTORY_SEPARATOR.'configuration';

    const ZONE_BASEDIR = self::BASEDIR.DIRECTORY_SEPARATOR.'primary';

    public function user_dashboard()
    {
        $data['title'] = 'User Dashboard';
        $user_id = Auth::id();
        $renew=0;
        $periods=DB::table('misc_settings')->first();
        $expiredate=Auth::user()->domainExpiryDate;
        $creationdate=Auth::user()->domainCreationDate;
        $today=date('Y-m-d H:i:s');
        $lastdate=Carbon::parse($expiredate)->addDays($periods->hold_domain_period+$periods->restorable_domain_period)->format('Y-m-d H:i:s');
        $renewshowdate  = Carbon::parse($creationdate)->addDays(5)->format('Y-m-d H:i:s');
        if(Auth::user()->domainStatus>=6 && $lastdate>$today){
            $renew=1;
        }
        $data['renew'] = $renew;
        $data['renewshowdate'] = $renewshowdate;
        $data['todaydate'] = date('Y-m-d H:i:s');
        return view('user.pages/index',$data);
    }

    public function domain_contact_details()
    {
        $data['title'] = 'Domain Contact Details';
        return view('user.pages/domain-contact-details',$data);
    }

    public function getPaymenthistory(){
        $data['title'] = 'Payment History';
        return view('user.pages/pay',$data);   
    }

    public function user_pay_ajaxcall(Request $request){

         $draw = $request->get('draw');
         $start = $request->get("start");
         $rowperpage = $request->get("length"); 
 
         $columnIndex_arr = $request->get('order');
         $columnName_arr = $request->get('columns');
         $order_arr = $request->get('order');
         $search_arr = $request->get('search');
 
         $columnIndex = $columnIndex_arr[0]['column']; 
         $columnName = $columnName_arr[$columnIndex]['data']; 
         $columnSortOrder = $order_arr[0]['dir']; 
         $searchValue = $search_arr['value']; 
 
         $countData = DB::table('transactions')->select('count(*) as allcount')->where('user_id',Auth::user()->id)
         ->where('transaction_status','0300');
 
         if($searchValue != null) {
            $countData->where('response_payload', 'like', '%' .$searchValue . '%');
         }
 
         $totalRecordswithFilter = $countData->count();
         $totalRecords = $totalRecordswithFilter;
         $records = DB::table('transactions')->select('*')->where('user_id',Auth::user()->id)
             ->where('transaction_status','0300')
             ->skip($start)
             ->take($rowperpage)
             ->orderBy('id','desc');

 
         if($searchValue != null) {
            $records->where('response_payload', 'like', '%' .$searchValue . '%');
         }
 
         $list = $records->get();
         $data_arr = array();
 
         foreach($list as $sno => $record){
             if($record->response_payload){
                 $id = $record->id;
                 $txnAmount = $record->total_amount;
                 $created_at = Carbon::parse($record->created_at)->format('d-m-Y');

                 $type='';

                 $detail = json_decode($record->request);
                 
                 if($record->transaction_type=='domainRegister'){
                     $type='Domain Fee';
                 }else if($record->transaction_type=='nameServerUpdate'){
                    $type='Ernet Name Server Fee';
                 }else if($record->transaction_type=='domainRenewal'){
                    $type='Domain Renewal Fee';
                 }else if($record->transaction_type=='domainRegisterWithNameServer'){
                    $type='DNS Fee';
                    $txnAmount = $detail->dns_amount??0;
                 }else if($record->transaction_type=='userNameServerUpdate'){
                    $type='Name Server Update Fee';
                }
                 else if($record->transaction_type=='ewaas'){
                    $type='EWaaS Service';
                 }else if($record->transaction_type=='elmaas'){
                    $type='ELmaaS Service';
                 }else{
                    $type=$record->transaction_type;
                 }

                 


if($record->transaction_type=='domainRegisterWithNameServer')
{

    $data_arr[] = array(
        "id" => ++$start,
        "type" => 'Domain Fee',
        "txnAmount" => $detail->domain_amount??0,
        "created_at" => $created_at
    );
    
}                 $data_arr[] = array(
                     "id" => ++$start,
                     "type" => $type,
                     "txnAmount" => $txnAmount,
                     "created_at" => $created_at
                 );
             }
         }
         $response = array(
             "draw" => intval($draw),
             "iTotalRecords" => count($data_arr),
             "iTotalDisplayRecords" => count($data_arr),
             "aaData" => $data_arr
         );
 
         echo json_encode($response);
         exit;

    }

    public function getVasPaymentHistory(){
        $data['title'] = 'VAS Payment History';
        return view('user.pages/vaspay',$data);   
    }

    public function user_pay_vas_ajaxcall(Request $request){

         $draw = $request->get('draw');
         $start = $request->get("start");
         $rowperpage = $request->get("length"); 
 
         $columnIndex_arr = $request->get('order');
         $columnName_arr = $request->get('columns');
         $order_arr = $request->get('order');
         $search_arr = $request->get('search');
 
         $columnIndex = $columnIndex_arr[0]['column']; 
         $columnName = $columnName_arr[$columnIndex]['data']; 
         $columnSortOrder = $order_arr[0]['dir']; 
         $searchValue = $search_arr['value']; 
 
         $countData = DB::table('transactions')->select('count(*) as allcount')->where('user_id',Auth::user()->id)
         ->whereIn('transaction_type',['elmaas','ewaas']);
         
 
         if($searchValue != null) {
            $countData->where('response_payload', 'like', '%' .$searchValue . '%');
         }
 
         $totalRecordswithFilter = $countData->count();
         $totalRecords = $totalRecordswithFilter;
         $records = DB::table('transactions')->select('*')->where('user_id',Auth::user()->id)->whereIn('transaction_type',['elmaas','ewaas'])
             ->skip($start)
             ->take($rowperpage);
 
         if($columnName == 'id') {
            $records->orderBy($columnName,$columnSortOrder);
         }
 
         if($searchValue != null) {
            $records->where('response_payload', 'like', '%' .$searchValue . '%');
         }
 
         $list = $records->get();
         $data_arr = array();
 
         foreach($list as $sno => $record){
             if($record->response_payload){
                 $id = $record->id;
                 $txnAmount = ltrim(json_decode($record->response_payload)->TxnAmount,0);
                 $created_at = Carbon::parse($record->created_at)->format('d/m/Y');

                 $type='';

                  if($record->transaction_type=='vas'){
                    $type='Value Added Service Charge';
                 }else{
                    $type=$record->transaction_type;
                 }
                 $data_arr[] = array(
                     "id" => ++$start,
                     "type" => $type,
                     "txnAmount" => $txnAmount,
                     "created_at" => $created_at
                 );
             }
         }
         $response = array(
             "draw" => intval($draw),
             "iTotalRecords" => $totalRecords,
             "iTotalDisplayRecords" => $totalRecordswithFilter,
             "aaData" => $data_arr
         );
 
         echo json_encode($response);
         exit;

    }

    public function domainContactDetailsList()
    {
        $user_id = Auth::id();
        $data = DB::table('user_contact_details')->where('user_id','=',$user_id)->first();
        return ['status'=> true , 'data' => $data, 'message'=> 'fetched successfully'];
    }
    public function add_contact_details(Request $request)
    {
        $data['title'] = 'Domain Contact Details';
        $data['states'] = DB::table('regions')->orderBy('description')->get();
        $data['cities'] = DB::table('cities')->get();
        if ($request->has('tab') && $request->tab != null){
            $data['tab'] = $request->tab;
        }
        return view('user.pages/add-contact-details',$data);
    }

    public function getCityByState($id)
    {
        $state = DB::table('regions')->where('description',$id)->first();
        return ['status'=>true, 'data'=> DB::table('cities')->where('region_id',$state->id)->get()];
    }

    public function verifyGst(Request $request)
    {
        $gstno = $request->input('gst');
        $cURLConnection = curl_init();

        curl_setopt($cURLConnection, CURLOPT_URL, 'https://commonapi.mastersindia.co/commonapis/searchgstin?gstin='.$gstno);
        curl_setopt($cURLConnection, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($cURLConnection, CURLOPT_HTTPHEADER, array(
            'Authorization: Bearer 0ab31ef7392227173c6e8d34195e86d5eb0da1e9',
            'client_id: JarZChUcsytSBbnkpt'
        ));

        $gstData = curl_exec($cURLConnection);
        curl_close($cURLConnection);
        if (str_contains(strtolower(json_decode($gstData)->data->lgnm),strtolower(Auth::user()->institute)) || str_contains(strtolower(Auth::user()->institute),strtolower(json_decode($gstData)->data->lgnm))){
            return ['status'=>true];
        }else{
            return ['status'=>false];
        }
    }
    public function updateInstitutionDetail(Request $request)
    {
        $user_id = Auth::id();
        $user = User::find($user_id);

        $data = [
            "address" => $request->input('address'),
            "state" => $request->input('state'),
            "city" => $request->input('city'),
            "pincode" => $request->input('pincode'),
            "phone" => $request->input('phone'),
            "prefix_phone" => $request->input('prefix_phone'),
            "mobile"=>$request->input('mobile'),
            "gst_no" => $request->input('gst'),
        ];

        $update=$user->update(['affilation_no'=>$request->affilation_no]);

        $status = DB::table('user_contact_details')
            ->updateOrInsert(
                ['user_id' => $user_id],
                $data
            );

            if($user->domainStatus>5){

                $epp = new EPP();
        
                $res = $epp->domainInfo($user->domainName);
                
                
               $output=xmlConverter($res);
        
                $r=$output['epp']['response'];
          
                $regId=$r['resData']['domain:infData']['domain:registrant'];
        
                $usercontact=DB::table('user_contact_details')->select('*')->where('user_id',$user->id)->first();
    
                $org=$user->institute;
                $name='';
                $address=$usercontact->address;
                $city=$usercontact->city;
                $state=$usercontact->state;
                $postcode=$usercontact->pincode;
                $email='';
                $mobileno='';
        
                $name=$user->name;
                $email=$user->email;
                $mobileno=$usercontact->mobile;
    
               $params=[
                'name'=>$name,
                'org'=>$this->removeSpecialCharacters($org),
                'address'=>$this->removeSpecialCharacters($address),
                'city'=>$this->removeSpecialCharacters($city),
                'state'=>$this->removeSpecialCharacters($state),
                'postcode'=>$postcode,
                'country'=>'IN',
                'mobile'=>'+91.'.$mobileno,
                'email'=>$email,
                ];
                    
    
                $result = $epp->contactUpdate($regId,$params);
            
    
            }


        return $status;
    }
    public function updateInstitutionHeadDetail(Request $request)
    {
        $user_id = Auth::id();
        $user = User::find($user_id);

        $data = $request->input('head');
        $status = DB::table('user_contact_details')
            ->updateOrInsert(
                ['user_id' => $user_id],
                ['institution_head_detail' => $data]
            );

            if($user->domainStatus>5){

                $epp = new EPP();
        
                $res = $epp->domainInfo($user->domainName);
                
                $output=xmlConverter($res);
        
                $r=$output['epp']['response'];
          
                $regId=$r['resData']['domain:infData']['domain:registrant'];
        
                $usercontact=DB::table('user_contact_details')->select('*')->where('user_id',$user->id)->first();
    
                $org=$user->institute;
                $name='';
                $address=$usercontact->address;
                $city=$usercontact->city;
                $state=$usercontact->state;
                $postcode=$usercontact->pincode;
                $email='';
                $mobileno='';
        
                $name=$user->name;
                $email=$user->email;
                $mobileno=$usercontact->mobile;
    
               $params=[
                'name'=>$name,
                'org'=>$this->removeSpecialCharacters($org),
                'address'=>$this->removeSpecialCharacters($address),
                'city'=>$this->removeSpecialCharacters($city),
                'state'=>$this->removeSpecialCharacters($state),
                'postcode'=>$postcode,
                'country'=>'IN',
                'mobile'=>'+91.'.$mobileno,
                'email'=>$email,
                ];
                    
    
                $result = $epp->contactUpdate($regId,$params);
            
    
            }
        
        return $status;
    }
    public function updateAdministrativeDetail(Request $request)
    {
        $user_id = Auth::id();
        $user = User::find($user_id);

        $data = $request->input('administrative');
        $status = DB::table('user_contact_details')
            ->updateOrInsert(
                ['user_id' => $user_id],
                ['administrative_detail' => $data]
            );

            if($user->domainStatus>5){

                $epp = new EPP();
        
                $res = $epp->domainInfo($user->domainName);
                
                $dom = new \DOMDocument();
                $dom->loadXML($res);
                
                $xpath = new \DOMXPath($dom);
                $xpath->registerNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                $regId = $xpath->query('//domain:contact[@type="admin"]');
                if ($regId->length > 0) {
                    $regId = $regId->item(0)->nodeValue;
                }
        
                $usercontact=DB::table('user_contact_details')->select('*')->where('user_id',$user->id)->first();
    
                $org=$user->institute;
                $name='';
                $address=$usercontact->address;
                $city=$usercontact->city;
                $state=$usercontact->state;
                $postcode=$usercontact->pincode;
                $email='';
                $mobileno='';
        
                $value=json_decode($usercontact->administrative_detail,true);

                $name=$value['name']??'';
                $email=$value['email']??'';
                $mobileno=$value['mobile']??'';
    
               $params=[
                'name'=>$name,
                'org'=>$this->removeSpecialCharacters($org),
                'address'=>$this->removeSpecialCharacters($address),
                'city'=>$this->removeSpecialCharacters($city),
                'state'=>$this->removeSpecialCharacters($state),
                'postcode'=>$postcode,
                'country'=>'IN',
                'mobile'=>'+91.'.$mobileno,
                'email'=>$email,
                ];
                        
                $result = $epp->contactUpdate($regId,$params);
            
    
            }

        return $status;
    }
    public function updateBillingDetail(Request $request)
    {
        $user_id = Auth::id();
        $user = User::find($user_id);

        $data = $request->input('billing');
        $status = DB::table('user_contact_details')
            ->updateOrInsert(
                ['user_id' => $user_id],
                ['billing_contact_detail' => $data]
            );

            if($user->domainStatus>5){

                $epp = new EPP();
        
                $res = $epp->domainInfo($user->domainName);
                
                $dom = new \DOMDocument();
                $dom->loadXML($res);
                
                $xpath = new \DOMXPath($dom);
                $xpath->registerNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                $regId = $xpath->query('//domain:contact[@type="billing"]');
                if ($regId->length > 0) {
                    $regId = $regId->item(0)->nodeValue;
                }
        
                $usercontact=DB::table('user_contact_details')->select('*')->where('user_id',$user->id)->first();
    
                $org=$user->institute;
                $name='';
                $address=$usercontact->address;
                $city=$usercontact->city;
                $state=$usercontact->state;
                $postcode=$usercontact->pincode;
                $email='';
                $mobileno='';
        
                $value=json_decode($usercontact->billing_contact_detail,true);

                $name=$value['name']??'';
                $email=$value['email']??'';
                $mobileno=$value['mobile']??'';
    
               $params=[
                'name'=>$name,
                'org'=>$this->removeSpecialCharacters($org),
                'address'=>$this->removeSpecialCharacters($address),
                'city'=>$this->removeSpecialCharacters($city),
                'state'=>$this->removeSpecialCharacters($state),
                'postcode'=>$postcode,
                'country'=>'IN',
                'mobile'=>'+91.'.$mobileno,
                'email'=>$email,
                ];
                        
                $result = $epp->contactUpdate($regId,$params);
            
    
            }

        return $status;
    }

    private function removeSpecialCharacters($string) {
        $cleanedString = preg_replace('/[^a-zA-Z0-9- \s]/', '', $string);    
        return $cleanedString;
    }
    
    public function updateTechnicalDetail(Request $request)
    {
        try {
            $user_id = Auth::id();
            $user = User::find($user_id);

            $data = $request->input('technical');
            $status = DB::table('user_contact_details')
                ->updateOrInsert(
                    ['user_id' => $user_id],
                    ['technical_detail' => $data]
                );

            if($user->domainStatus>5){

                    $epp = new EPP();
            
                    $res = $epp->domainInfo($user->domainName);
                    
                    $dom = new \DOMDocument();
                    $dom->loadXML($res);
                    
                    $xpath = new \DOMXPath($dom);
                    $xpath->registerNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                    $regId = $xpath->query('//domain:contact[@type="tech"]');
                    if ($regId->length > 0) {
                        $regId = $regId->item(0)->nodeValue;
                    }
            
                    $usercontact=DB::table('user_contact_details')->select('*')->where('user_id',$user->id)->first();
        
                    $org=$user->institute;
                    $name='';
                    $address=$usercontact->address;
                    $city=$usercontact->city;
                    $state=$usercontact->state;
                    $postcode=$usercontact->pincode;
                    $email='';
                    $mobileno='';
            
                    $value=json_decode($usercontact->technical_detail,true);
    
                    $name=$value['name']??'';
                    $email=$value['email']??'';
                    $mobileno=$value['mobile']??'';
        
                   $params=[
                    'name'=>$name,
                    'org'=>$this->removeSpecialCharacters($org),
                    'address'=>$this->removeSpecialCharacters($address),
                    'city'=>$this->removeSpecialCharacters($city),
                    'state'=>$this->removeSpecialCharacters($state),
                    'postcode'=>$postcode,
                    'country'=>'IN',
                    'mobile'=>'+91.'.$mobileno,
                    'email'=>$email,
                    ];
                            
                    $result = $epp->contactUpdate($regId,$params);
                
        
            }

            $updated_date = Carbon::now();
            $user = User::find($user_id);
            if ($user->domainStatus == 0){
                $user->domainStatus = 1;
            }
            $user->updated_at = $updated_date;
            $user->save();

            $authuser=Auth::user();
            $activity=['user_id'=>$authuser->id,'user_type'=>1,'user_name'=>$authuser->name,'domainName'=>$authuser->domainName,'status'=>'Contact Details Saved','ip_address'=>$request->ip()];
            handleActivity($activity);
            
            return ['status'=> true , 'msg'=> 'Technical Details saved successfully!'];
        } catch (Throwable $e) {
            return ['status'=>false, 'msg'=>$e->getMessage()];
        }
    }

    public function upload_documents()
    {
        $data['title'] = ' User Documents Upload';
        return view('user.pages/upload-documents',$data);
    }

    public function userDocsList()
    {
        $user_id = Auth::id();
        $data = DB::table('user_documents')->where('user_id','=',$user_id)->get();
        return ['status'=> true , 'data' => $data, 'message'=> 'fetched successfully'];
    }

    public function userDocsUpload(Request $request)
    {
        $file_format = DB::table('document_category')->where('id','=',$request->input('category_id'))->first();
        $size = 2048;

        $msg = [
            'file.mimes' => 'Kindly, upload pdf file only!',
            'file.max'=>'File Size should be less than 2MB'
        ];
                
        $validator = Validator::make($request->all(), [
            'file' => ['required', 'mimes:pdf', 'max:' . $size]
        ], $msg);

        if ($validator->fails()) {
            return response()->json(['status'=>false ,'error'=>$validator->errors()->first()]);
        }

        $user_id = Auth::id();
        $path = public_path('user/docs/').$user_id;

        if($request->hasFile('file'))
        {
            $doc = $request->file('file');

            $filename = time().$doc->getClientOriginalName();

            if (preg_match('/[\'^£$%&*}{@#~?><>,|=+¬]/', $filename))
            {
                return response()->json(['status' => false, 'error' => 'Selected file is not uploaded, The file name should contain only alphanumeric characters and should not contain any special characters like !@#$%^&*()_- = +']);
            }
            if($doc->move($path,$filename))
            {
                $oldpath='';
                $docprevoius=DB::table('user_documents')->where('user_id',$user_id)->where('document_category_id',$request->input('category_id'))->first();

                if($docprevoius!=null){
                   $oldpath=$docprevoius->path;
                }

                $status = DB::table('user_documents')
                    ->updateOrInsert(
                        ['user_id' => $user_id,'document_category_id' => $request->input('category_id')],
                        [
                            'user_id' => $user_id,
                            'document_category_id' => $request->input('category_id'),
                            'name' => pathinfo($filename, PATHINFO_FILENAME),
                            'path' => $filename,
                            'old_path' => $oldpath,
                            'status' => 1
                        ]
                    );
                return response()->json(['status' => true, 'msg' => 'Document has been uploaded successfully']);
            }
            else
            {
                return response()->json(['status' => false, 'error' => ' Document not uploaded']);
            }
        }
        else
        {
            return response()->json(['status' => false, 'error' => 'Please Upload Document']);
        }
    }


    public function checkanydocumentrequired()
    {

        $user_id = Auth::id();
        $ext = DB::table('domain_extensions')->where('id',Auth::user()->domainExtensionID)->first();
        $ids  = explode(",",$ext->doc_ids);
        $doc_type = DB::table('document_category')->whereIn('id',$ids)->get();
        foreach ($doc_type as $type){

            if($type->id!=13){

            $docs = DB::table('user_documents')
                ->where('user_id','=', $user_id)
                ->whereIn('status',[1,2])
                ->where('document_category_id','=', $type->id)->first();
            if ($docs == null){
                $msg = $type->title;
                return response()->json(['status' => false, 'message' => ' Document not  uploaded']);
            }

            }

        }

        return response()->json(['status' => true, 'message' => ' Document  uploaded']);

    }

    public function user_submit_documents(Request $request)
    {
        $user_id = Auth::id();
        $ext = DB::table('domain_extensions')->where('id',Auth::user()->domainExtensionID)->first();
        $ids  = explode(",",$ext->doc_ids);
        $doc_type = DB::table('document_category')->whereIn('id',$ids)->get();
        foreach ($doc_type as $type){

            if($type->id!=13){

            $docs = DB::table('user_documents')
                ->where('user_id','=', $user_id)
                ->whereIn('status',[1,2])
                ->where('document_category_id','=', $type->id)->first();
            if ($docs == null){
                $msg = $type->title;
                Session::flash('message', $msg.' is required');
                Session::flash('alert-class', 'alert-danger');
                return back();
            }

            }
          
        }
        $updated_date = Carbon::now();
        $user = User::find($user_id);
        if ($user->domainStatus < 6){
            $user->domainStatus = 4;
        }
        $user->document_status = 0;
        $user->updated_at = $updated_date;
        $saved=$user->save();

        $authuser=Auth::user();
        $activity=['user_id'=>$authuser->id,'user_type'=>1,'user_name'=>$authuser->name,'domainName'=>$authuser->domainName,'status'=>'Document Submitted','ip_address'=>$request->ip()];
        handleActivity($activity); 
        
        if($user->domainStatus>5){

            if($user->domainStatus==10){
                return redirect('user-application-preview');
            }

            $user_id = Auth::id();
            $ext = DB::table('domain_extensions')->where('id',Auth::user()->domainExtensionID)->first();
            $ids  = explode(",",$ext->doc_ids);
    
            $langs= $ext->domain_language_id==2?1:2;

            $user=Auth::user();
            $userExpiryDate = Carbon::parse($user->domainExpiryDate);
            $maxdate = now()->addYears(10);
    
            $allowyears = $maxdate->diffInYears($userExpiryDate);
     
            $data['renew_prices'] = DB::table('domain_extension_prices')->where('domain_extension_id',$langs)->where('year','<=',$allowyears)->orderBy('year','asc')->get();
           
            $data['extra_charge'] = 0;
            $setting = DB::table('misc_settings')->first();

            if(Auth::user()->domainStatus==7){
                $data['extra_charge'] = $setting->reactivation_price ?? 0;
            }
               
            if(Auth::user()->domainStatus==8){    
                $data['extra_charge'] = $setting->hold_deduction_price ?? 0;
            }

            $data['title'] = 'Renew Domain';

            return view('user.pages/renew-domain',$data);
        }
     
        return redirect('user-application-preview');
    }

    public function user_renew_domain()
    {
        $user_id = Auth::id();
        $user=Auth::user();
        $ext = DB::table('domain_extensions')->where('id',Auth::user()->domainExtensionID)->first();
        $ids  = explode(",",$ext->doc_ids);

        if($user->domainStatus!=10 ){

            $renewal=DB::table('domain_trails')->where('user_id',$user_id)->latest('id')->first();
                  
            if($renewal!=null && $user->domainStatus==6){

                $expiryDate = Carbon::parse($renewal->created_at);
                $currentDate = Carbon::now();
        
                if ($currentDate->diffInDays($expiryDate) >= 40) {
        
                  $update = DB::table('user_documents')
                  ->where('user_id','=', $user_id)
                  // ->where('document_category_id','!=', 13)
                  ->update(['status'=>1]);

                 }
                  
            }else{

                $update = DB::table('user_documents')
                ->where('user_id','=', $user_id)
                // ->where('document_category_id','!=', 13)
                ->update(['status'=>1]);

            }
          

        }


              $langs= $ext->domain_language_id==2?1:2;

              $userExpiryDate = Carbon::parse($user->domainExpiryDate);
              $maxdate = now()->addYears(10);

              $allowyears = $maxdate->diffInYears($userExpiryDate);


                $data['renew_prices'] = DB::table('domain_extension_prices')->where('domain_extension_id',$langs)->where('year','<=',$allowyears)->orderBy('year','asc')->get();
       
        $data['extra_charge'] = 0;
        $setting = DB::table('misc_settings')->first();
            
        if(Auth::user()->domainStatus==7){
            $data['extra_charge'] = $setting->reactivation_price ?? 0;
        }
            
        if(Auth::user()->domainStatus==8){
            $data['extra_charge'] = $setting->hold_deduction_price ?? 0;
        }

        $data['title'] = 'Renew Domain';
        return view('user.pages/upload-documents',$data);

    }
    public function dns_name_server()
    {
        $user_id = Auth::id();
         
        $period=Auth::user()->domainPeriod;

        $user_dns = DB::table('user_name_servers')->where('user_id','=', $user_id)->first();
        if ($user_dns == null){
            $data['title'] = 'Add DNS Name Server';
            $data['ernet_name_server'] = DB::table('ernet_name_servers')->where('status','=',1)->first();
            $data['ernet_name_server_prices'] = DB::table('ernet_name_servers_prices')->where('ernet_name_server_id','=',$data['ernet_name_server']->id)
            ->where(
                'years','<=',$period
            )->orderBy('years','asc')->get();
            $data['user_name_server'] = null;
            $data['dns_security_extension'] = null;
            $data['algos']=DB::table('algo_master')->get();
            $data['dnscount'] = 0;

            return view('user.pages/add-name-server',$data);
        }else{
            
            $data['title'] = 'Add DNS Name Server';
            $data['ernet_name_server'] = DB::table('ernet_name_servers')->where('status','=',1)->first();
            $data['ernet_name_server_prices'] = DB::table('ernet_name_servers_prices')->where('ernet_name_server_id','=',$data['ernet_name_server']->id) ->where(
                'years','<=',$period
            )->orderBy('years','asc')->get();
            $data['user_name_server'] = $user_dns;
            $data['algos']=DB::table('algo_master')->get();
            $data['dnscount'] = DB::table('dns_security-extension')->where('user_dns_server_id','=',$user_dns->id)->count();

            $data['dns_security_extension'] = DB::table('dns_security-extension')->where('user_dns_server_id','=',$user_dns->id)->get();
            return view('user.pages/add-name-server',$data);
        }

    }

    public function getNameServerPrice($name_server_id)
    {
        $data =  DB::table('ernet_name_servers_prices')->where('id','=',$name_server_id)->first();
        if ($data != null){
            return['status'=> true, 'msg' => 'data fetched', 'data'=>$data];
        }else{
            return['status'=> true, 'data'=>$data];
        }

    }
public function getVasServerPrice($name_server_id)
    {
        $data =  DB::table('ernet_name_servers_prices')->where('id','=',$name_server_id)->first();
        if ($data != null){
            return['status'=> true, 'msg' => 'data fetched', 'data'=>$data];
        }else{
            return['status'=> true, 'data'=>$data];
        }

    }

    public function checkDNSonNixi(Request $request,$id){

        $epp = new EPP();
    
        $res = $epp->hostInfo($id);

        dd($res);

    }

    public function checkDNSMatch(Request $request)
    {
        $domain = $request->input('domain');

        if ($domain != null){

            $validPatterns = '(\.ac\.in|\.edu\.in|\.res\.in)$';

            if (preg_match('/' . $validPatterns . '/', $domain)) {
                return true;
            } else {
                return false;
            }

        }


    }

    public function userApplicationPreview()
    {
        $user_id = Auth::id();
        $data['title'] = 'User Domain Application Preview';
        $data['user_contact_details'] = DB::table('user_contact_details')->where('user_id','=',$user_id)->first();
        $data['user_name_server'] = DB::table('user_name_servers')->where('user_id','=',$user_id)->first();
        $data['user_documents'] = DB::table('user_documents')->where('user_id','=',$user_id)->get();
        $userdocuments=DB::table('user_documents')->select('user_documents.*','document_category.title')->where('user_id',$user_id)->join('document_category','document_category.id','user_documents.document_category_id')->get();
        $data['userdocuments'] = $userdocuments;
        return view('user.pages.user-application-preview',$data);

    }

    public function userApplicationSubmit(Request $request)
    {
        $user_id = Auth::id();
        $ext = DB::table('domain_extensions')->where('id',Auth::user()->domainExtensionID)->first();
        $ids  = explode(",",$ext->doc_ids);
        $doc_type = DB::table('document_category')->whereIn('id',$ids)->get();
        foreach ($doc_type as $type){

            if($type->id!=13){

            $docs = DB::table('user_documents')
                ->where('user_id','=', $user_id)
                ->whereIn('status',[1,2])
                ->where('document_category_id','=', $type->id)->first();
            if ($docs == null){
                return ['status'=> false, 'message'=> 'Kindly upload all documents for final submit .'];
            }

            }
         
        }

        $checktransaction=DB::table('transactions')->where('transaction_status','0300')
        ->whereIn('transaction_type',['domainRegister','domainRegisterWithNameServer'])
        ->where('user_id',$user_id)->count();

        $user_id = Auth::id();

        if($checktransaction==0){

            $user = User::find($user_id);
            $user->domainStatus = 1;
            $saved=$user->save();

            return ['status'=> 'update'];

        }else{

          $updated_date = date('Y-m-d H:i:s');
          $user = User::find($user_id);
          $user->domainStatus = 5;
          $user->document_status = 0;
          $user->updated_at = $updated_date;
          $user->applicationDate = $updated_date;
          $saved=$user->save();
          
          $authuser=Auth::user();
          $activity=['user_id'=>$authuser->id,'user_type'=>1,'user_name'=>$authuser->name,'domainName'=>$authuser->domainName,'status'=>'Final Application Submitted','ip_address'=>$request->ip()];
          handleActivity($activity); 
          
        }

        return ['status'=> true];
    }

    public function addDnsNameServerErnet(Request $request)
    {
        try {
            $user_id = Auth::id();
            $request->validate([
                'primary_name_server_ernet' => 'required',
            ]);

            $data = [
                "user_id" => $user_id,
                "server_type" => 1,
                "dns_service_duration" => $request->input('dns_service_duration'),
                "server_price" => $request->input('server_price'),
                "server_price_tax" => $request->input('server_price_tax'),
                "offer_discount" => $request->input('offer_discount'),
                "server_price_total" => $request->input('server_price_total'),
                "primary_name_server" => $request->input('primary_name_server_ernet'),
                "secondary_name_server1" => $request->input('secondary_name_server_ernet1'),
                "secondary_name_server2" => $request->input('secondary_name_server_ernet2'),
                "secondary_name_server3" => $request->input('secondary_name_server_ernet3'),
                "secondary_name_server4" =>  $request->input('secondary_name_server_ernet4'),
                "secondary_name_server5" =>$request->input('secondary_name_server_ernet5'),
                "ernet_name_server_duration_year" => $request->input('years'),
                "years"=>$request->input('years')
            ];

            $user_dns = DB::table('user_name_servers')->where('server_type','!=',3)->where('user_id','=', Auth::id())->first();

            if($user_dns){

                if($user_dns->server_type==1 &&  $user_dns->ernet_name_server_duration_year==$request->input('years')){

                    $authuser=Auth::user();

                    if(Auth::user()->domainStatus<6){
                        $data['title'] = ' User Documents Upload';
                        $activity=['user_id'=>$authuser->id,'user_type'=>1,'user_name'=>$authuser->name,'domainName'=>$authuser->domainName,'status'=>'Name Server Added (ERNET)','ip_address'=>$request->ip()];
                        handleActivity($activity);    
                        return view('user.pages/upload-documents',$data);
                    }else{
                        $activity=['user_id'=>$authuser->id,'user_type'=>1,'user_name'=>$authuser->name,'domainName'=>$authuser->domainName,'status'=>'Name Server Updated (ERNET)','ip_address'=>$request->ip()];
                        handleActivity($activity);    
                        return redirect('user-application-preview');
                    }

                }

            }
             
            Session::put('data',$data);
            return redirect('dns-name-server-payment');

        } catch (Throwable $e) {
            Session::flash('message', $e->getMessage());
            Session::flash('alert-class', 'alert-danger');
            return back();
        }
    }

    public function addDnsNameServerUser(Request $request)
    {
        try {
            $user_id = Auth::id();
            $request->validate([
                'primary_name_server' => ['required', 'regex:/^(?!\-)([a-zA-Z0-9\-]+\.)+[a-zA-Z]{2,}$/'],
                'secondary_name_server1' => ['nullable', 'regex:/^(?!\-)([a-zA-Z0-9\-]+\.)+[a-zA-Z]{2,}$/'],
                'secondary_name_server2' => ['nullable', 'regex:/^(?!\-)([a-zA-Z0-9\-]+\.)+[a-zA-Z]{2,}$/'],
                'secondary_name_server3' => ['nullable', 'regex:/^(?!\-)([a-zA-Z0-9\-]+\.)+[a-zA-Z]{2,}$/'],
                'secondary_name_server4' => ['nullable', 'regex:/^(?!\-)([a-zA-Z0-9\-]+\.)+[a-zA-Z]{2,}$/'],
                'secondary_name_server5' => ['nullable', 'regex:/^(?!\-)([a-zA-Z0-9\-]+\.)+[a-zA-Z]{2,}$/'],
            ], [
                'primary_name_server.regex' => 'Primary Name Server must be in domain format like ns1.example.com',
                'secondary_name_server1.regex' => 'Secondary Name Server must be in domain format like ns2.example.com',
                'secondary_name_server2.regex' => 'Secondary Name Server must be in domain format like ns3.example.com',
                'secondary_name_server3.regex' => 'Secondary Name Server must be in domain format like ns4.example.com',
                'secondary_name_server4.regex' => 'Secondary Name Server must be in domain format like ns5.example.com',
                'secondary_name_server5.regex' => 'Secondary Name Server must be in domain format like ns6.example.com',
            ]);
            $data = [
                "user_id" => $user_id,
                "server_type" => 2,
                "primary_name_server" => $request->input('primary_name_server'),
                "primary_name_server_ip" => ($request->input('primary_name_server_ip')== null)? '': implode('.',$request->input('primary_name_server_ip')) ,
                "secondary_name_server1" => $request->input('secondary_name_server1'),
                "secondary_name_server2" => $request->input('secondary_name_server2'),
                "secondary_name_server3" => $request->input('secondary_name_server3'),
                "secondary_name_server4" =>  $request->input('secondary_name_server4'),
                "secondary_name_server5" =>$request->input('secondary_name_server5'),
                "ernet_name_server_duration_year" => null,
                "enable_dnsse_no"=>$request->enable_dnsse,
                "secondary_name_server1_ip" => ($request->input('secondary_name_server1_ip')== null)? '': implode('.',$request->input('secondary_name_server1_ip')) ,
                "secondary_name_server2_ip" => ($request->input('secondary_name_server2_ip')== null)? '': implode('.',$request->input('secondary_name_server2_ip')) ,
                "secondary_name_server3_ip" => ($request->input('secondary_name_server3_ip')== null)? '': implode('.',$request->input('secondary_name_server3_ip')) ,
                "secondary_name_server4_ip" => ($request->input('secondary_name_server4_ip')== null)? '': implode('.',$request->input('secondary_name_server4_ip')) ,
                "secondary_name_server5_ip" => ($request->input('secondary_name_server5_ip')== null)? '': implode('.',$request->input('secondary_name_server5_ip')) ,
                "primary_name_server_ip6" => ($request->input('primary_name_server_ip6')== null)? '': implode(':',$request->input('primary_name_server_ip6')) ,
                "secondary_name_server1_ip6" => ($request->input('secondary_name_server1_ip6')== null)? '': implode(':',$request->input('secondary_name_server1_ip6')) ,
                "secondary_name_server2_ip6" => ($request->input('secondary_name_server2_ip6')== null)? '': implode(':',$request->input('secondary_name_server2_ip6')) ,
                "secondary_name_server3_ip6" => ($request->input('secondary_name_server3_ip6')== null)? '': implode(':',$request->input('secondary_name_server3_ip6')) ,
                "secondary_name_server4_ip6" => ($request->input('secondary_name_server4_ip6')== null)? '': implode(':',$request->input('secondary_name_server4_ip6')) ,
                "secondary_name_server5_ip6" => ($request->input('secondary_name_server5_ip6')== null)? '': implode(':',$request->input('secondary_name_server5_ip6'))
            ];
            $user_dns = DB::table('user_name_servers')->where('user_id','=', $user_id)->first();
            if ($user_dns == null){
               
                Session::put('data',$data);

                if ($request->input('enable_dnsse') == 'yes'){
                    Session::put('dnsse_data',$request->input('dnsse'));
                }

                if(Auth::user()->domainStatus<3){
                    return  redirect('domain-payment');
                }
                Session::flash('message', 'DNS Name Server Saved Successfully');
                Session::flash('alert-class', 'alert-success');
                return  redirect('user-application-preview');

            }else if($user_dns != null && Auth::user()->domainStatus!=6){     

            $user_id = Auth::id();
            $request->validate([
                'primary_name_server' => ['required', 'regex:/^(?!\-)([a-zA-Z0-9\-]+\.)+[a-zA-Z]{2,}$/'],
                'secondary_name_server1' => ['nullable', 'regex:/^(?!\-)([a-zA-Z0-9\-]+\.)+[a-zA-Z]{2,}$/'],
                'secondary_name_server2' => ['nullable', 'regex:/^(?!\-)([a-zA-Z0-9\-]+\.)+[a-zA-Z]{2,}$/'],
                'secondary_name_server3' => ['nullable', 'regex:/^(?!\-)([a-zA-Z0-9\-]+\.)+[a-zA-Z]{2,}$/'],
                'secondary_name_server4' => ['nullable', 'regex:/^(?!\-)([a-zA-Z0-9\-]+\.)+[a-zA-Z]{2,}$/'],
                'secondary_name_server5' => ['nullable', 'regex:/^(?!\-)([a-zA-Z0-9\-]+\.)+[a-zA-Z]{2,}$/'],
            ], [
                'primary_name_server.regex' => 'Primary Name Server must be in domain format like ns1.example.com',
                'secondary_name_server1.regex' => 'Secondary Name Server must be in domain format like ns2.example.com',
                'secondary_name_server2.regex' => 'Secondary Name Server must be in domain format like ns3.example.com',
                'secondary_name_server3.regex' => 'Secondary Name Server must be in domain format like ns4.example.com',
                'secondary_name_server4.regex' => 'Secondary Name Server must be in domain format like ns5.example.com',
                'secondary_name_server5.regex' => 'Secondary Name Server must be in domain format like ns6.example.com',
            ]);

            $data = [
                "user_id" => $user_id,
                "server_type" => 2,
                "primary_name_server" => $request->input('primary_name_server'),
                "primary_name_server_ip" => ($request->input('primary_name_server_ip')== null)? '': implode('.',$request->input('primary_name_server_ip')) ,
                "secondary_name_server1" => $request->input('secondary_name_server1'),
                "secondary_name_server2" => $request->input('secondary_name_server2'),
                "secondary_name_server3" => $request->input('secondary_name_server3'),
                "secondary_name_server4" =>  $request->input('secondary_name_server4'),
                "secondary_name_server5" =>$request->input('secondary_name_server5'),
                "ernet_name_server_duration_year" => null,
                "enable_dnsse_no"=>$request->enable_dnsse,
                "secondary_name_server1_ip" => ($request->input('secondary_name_server1_ip')== null)? '': implode('.',$request->input('secondary_name_server1_ip')) ,
                "secondary_name_server2_ip" => ($request->input('secondary_name_server2_ip')== null)? '': implode('.',$request->input('secondary_name_server2_ip')) ,
                "secondary_name_server3_ip" => ($request->input('secondary_name_server3_ip')== null)? '': implode('.',$request->input('secondary_name_server3_ip')) ,
                "secondary_name_server4_ip" => ($request->input('secondary_name_server4_ip')== null)? '': implode('.',$request->input('secondary_name_server4_ip')) ,
                "secondary_name_server5_ip" => ($request->input('secondary_name_server5_ip')== null)? '': implode('.',$request->input('secondary_name_server5_ip')) ,
                "primary_name_server_ip6" => ($request->input('primary_name_server_ip6')== null)? '': implode(':',$request->input('primary_name_server_ip6')) ,
                "secondary_name_server1_ip6" => ($request->input('secondary_name_server1_ip6')== null)? '': implode(':',$request->input('secondary_name_server1_ip6')) ,
                "secondary_name_server2_ip6" => ($request->input('secondary_name_server2_ip6')== null)? '': implode(':',$request->input('secondary_name_server2_ip6')) ,
                "secondary_name_server3_ip6" => ($request->input('secondary_name_server3_ip6')== null)? '': implode(':',$request->input('secondary_name_server3_ip6')) ,
                "secondary_name_server4_ip6" => ($request->input('secondary_name_server4_ip6')== null)? '': implode(':',$request->input('secondary_name_server4_ip6')) ,
                "secondary_name_server5_ip6" => ($request->input('secondary_name_server5_ip6')== null)? '': implode(':',$request->input('secondary_name_server5_ip6'))
            ];

                $tcount=DB::table('transactions')->where('transaction_status','0300')
                ->whereIn('transaction_type',['domainRegister','domainRegisterWithNameServer'])
                ->where('user_id',$user_id)->count();

                if($tcount==0){

                    Session::put('data',$data);

                    if ($request->input('enable_dnsse') == 'yes'){
                        Session::put('dnsse_data',$request->input('dnsse'));
                    }
    
                    return  redirect('domain-payment');

                }else{

                    $user_dns = DB::table('user_name_servers')->where('user_id','=', $user_id)->first();
                    $dns_id = DB::table('user_name_servers')
                            ->where('user_id',$user_id)
                            ->update(
                            $data
                    );

                        if ($request->input('enable_dnsse') == 'yes'){
                            DB::table('dns_security-extension')->where('user_dns_server_id','=',$dns_id)->delete();
                            if($request->input('dnsse')!=null){
                            foreach ($request->input('dnsse') as $dnssec){
                                if ($dnssec['key_tag'] != null){
                                    $dnssec['user_dns_server_id'] = $dns_id;
                                    DB::table('dns_security-extension')->insert($dnssec);
                                }
                            }
                           }
                        }

                }

                $authuser=Auth::user();
                $activity=['user_id'=>$authuser->id,'user_type'=>1,'user_name'=>$authuser->name,'domainName'=>$authuser->domainName,'status'=>'Name Server Updated','ip_address'=>$request->ip()];
                handleActivity($activity); 

                Session::flash('message', 'DNS Name Server Saved Successfully');
                Session::flash('alert-class', 'alert-success');
                return  redirect('user-application-preview');
            
            }else{


                $dns_id = DB::table('user_name_servers')
                ->where('user_id',$user_id)
                ->update(
                $data
                );

                if ($request->input('enable_dnsse') == 'yes'){
                    DB::table('dns_security-extension')->where('user_dns_server_id','=',$dns_id)->delete();
                    if($request->input('dnsse')!=null){
                    foreach ($request->input('dnsse') as $dnssec){
                        if ($dnssec['key_tag'] != null){
                            $dnssec['user_dns_server_id'] = $dns_id;
                            DB::table('dns_security-extension')->insert($dnssec);
                        }
                    }
                   }
                }

               
                $namserver=DB::table('user_name_servers')->where('user_id',$user_id)->first();
    
                $savedns=[
                    $namserver->primary_name_server,
                    $namserver->secondary_name_server1,
                ];
            
                $paramscreate=[
                    'ns1'=>[
                        'host'=>$namserver->primary_name_server,
                        'ip4'=>$namserver->primary_name_server_ip,
                        'ip6'=>$namserver->primary_name_server_ip6,
                    ],
                    'ns2'=>[
                        'host'=>$namserver->secondary_name_server1,
                        'ip4'=>$namserver->secondary_name_server1_ip,
                        'ip6'=>$namserver->secondary_name_server1_ip6,
                    ],
                ];
            
                if($namserver->secondary_name_server2!=null){
                    $paramscreate['ns3']=[
                        'host'=>$namserver->secondary_name_server2,
                        'ip4'=>$namserver->secondary_name_server2_ip,
                        'ip6'=>$namserver->secondary_name_server2_ip6,
                    ];
                    array_push($savedns,$namserver->secondary_name_server2);
                }
            
                if($namserver->secondary_name_server3!=null){
                    $paramscreate['ns4']=[
                        'host'=>$namserver->secondary_name_server3,
                        'ip4'=>$namserver->secondary_name_server3_ip,
                        'ip6'=>$namserver->secondary_name_server3_ip6,
                    ];
                    array_push($savedns,$namserver->secondary_name_server3);
                }
            
                if($namserver->secondary_name_server4!=null){
                    $paramscreate['ns5']=[
                        'host'=>$namserver->secondary_name_server4,
                        'ip4'=>$namserver->secondary_name_server4_ip,
                        'ip6'=>$namserver->secondary_name_server4_ip6,
                    ];
                    array_push($savedns,$namserver->secondary_name_server4);
                }
            
                if($namserver->secondary_name_server5!=null){
                    $paramscreate['ns6']=[
                        'host'=>$namserver->secondary_name_server5,
                        'ip4'=>$namserver->secondary_name_server5_ip,
                        'ip6'=>$namserver->secondary_name_server5_ip6,
                    ];
                    array_push($savedns,$namserver->secondary_name_server5);
                }
            
                $epp=new EPP();
            
                $user = DB::table('users')->where('id',$user_id)->first();
            
                $respone=$epp->domainInfo($user->domainName);
            
                $xml = new \SimpleXMLElement($respone);

                $xmlElement = new \SimpleXMLElement($respone);
                $xmlElement->registerXPathNamespace('secDNS', 'urn:ietf:params:xml:ns:secDNS-1.1');
            
                $dsDataArray = [];
                $dsDataElements = $xmlElement->xpath('//secDNS:dsData');
            
                if($dsDataElements!=null){
                    foreach ($dsDataElements as $dsDataElement) {
                        $dsDataArray[] = [
                            'keyTag' => (string) $dsDataElement->children('secDNS', true)->keyTag,
                            'alg' => (string) $dsDataElement->children('secDNS', true)->alg,
                            'digestType' => (string) $dsDataElement->children('secDNS', true)->digestType,
                            'digest' => (string) $dsDataElement->children('secDNS', true)->digest
                        ];
                    }
                    $res=$epp->domainremDNSSEC($user->domainName,$dsDataArray);
                }
            
                $xml->registerXPathNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
            
                $nameservers = $xml->xpath('//domain:hostObj');
            
                $remNSD = array();
                foreach ($nameservers as $nameserver) {
                 $remNSD[] = (string) $nameserver;
                }
          
                $res=$epp->domainupdateNameServerLatest($user->domainName,$paramscreate,$savedns,$remNSD);
                
                $dsdtaas=DB::table('dns_security-extension')->where('user_dns_server_id',$namserver->id)->get();

                $addDsData=[];

                foreach ($dsdtaas as $name) {
                    if($name->key_tag!=null || $name->key_tag!=''){
                    $addDsData[] = [
                        'keyTag' => $name->key_tag,
                        'alg' => $name->algorithm,
                        'digestType' => $name->digest_type,
                        'digest' => $name->digest,
                    ];
                    }
                }

                $res=$epp->domainupdateDNSSEC($user->domainName,$addDsData);

                $authuser=Auth::user();
                $activity=['user_id'=>$authuser->id,'user_type'=>1,'user_name'=>$authuser->name,'domainName'=>$authuser->domainName,'status'=>'Name Server Updated','ip_address'=>$request->ip()];
                handleActivity($activity); 

                return  redirect('user-application-preview');

            }
        } catch (Throwable $e) {
            Session::flash('message', $e->getMessage());
            Session::flash('alert-class', 'alert-danger');
            return back();
        }
    }

    public function format_pdf($id)
    {

        $user_id = Auth::id();
        $users = User::find($user_id);

        $details = DB::table('user_contact_details')->where('user_id', $user_id)->first();

        $nameserver = DB::table('user_name_servers')->where('user_id','=',$user_id)->first();
        $prices='';

        if($nameserver){
        if($nameserver->server_type==1){
            $prices=DB::table('ernet_name_servers_prices')->where('years','=',$nameserver->ernet_name_server_duration_year)->first();
        }
        }

        view()->share('users', $users);
        view()->share('details', $details);
        view()->share('detail', $users);        
        view()->share('nameserver', $nameserver);
        view()->share('prices', $prices);

        if ($id) {

            switch ($id) {
                case 1:
                    $view_path = 'Annexure_A';
                    $downloadname = 'Letter of Undertaking';
                    break;
                case 2:
                    $view_path = 'Annexure_B';
                    $downloadname = 'Application Letter';
                    break;
                    
                case 6:
                    $view_path = 'Authorization';
                    $downloadname = 'Letter of Authorization';
                    break;
                default:
                    $view_path = 'Annexure';
                    $downloadname = 'Annexure';
            }
            
            $viewurl='document.' . $view_path;

            $pdfname=$downloadname;
             $pdf = PDF::loadView($viewurl);
            return $pdf->download($pdfname.'.pdf');

        }

        return true;
    }

    public function textToImage($txt)
    {
        $img = imagecreate(500, 100);
        $textbgcolor = imagecolorallocate($img, 255, 255, 255);
        $textcolor = imagecolorallocate($img, 0, 0, 0);
        if ($txt!= '') {
            imagestring($img, 5, 5, 5, $txt, $textcolor);
            ob_start();
            imagepng($img);
            return printf('<img src="data:image/png;base64,%s"/>', base64_encode(ob_get_clean()));
        }
    }


    public function dns_name_server_payment()
    {
        $data['title'] = 'Payment Summary';
        $data['domainData'] = User::find(Auth::id());

        $user_dns = DB::table('user_name_servers')->where('server_type','!=',3)->where('user_id','=', Auth::id())->first();

        $ernet_name_server = DB::table('user_name_servers')->where('user_id','=', Auth::id())->first();

        $data['ernet_name_server']=$ernet_name_server;
        
        if (Auth::user()->domainStatus == 6){
            return view('user.pages/ernet-name-server-payment',$data);
        }else if(Auth::user()->domainStatus != 6 && $user_dns==null){
            return view('user.pages/name-server-payment',$data);
        }else{
            return view('user.pages/ernet-name-server-payment',$data);
        }
    }
    public function domain_payment()
    {
        $data['title'] = 'Dns Server Payment';
        $data['domainData'] = User::find(Auth::id());
        return view('user.pages/domain-payment',$data);
    }

    public function domain_payment_dns_skip()
    {
        $data['title'] = 'Dns Server Payment';
        $data['domainData'] = User::find(Auth::id());
        DB::table('user_name_servers')->updateOrInsert(
            [
                'user_id' => Auth::id()
            ],
            [
                'user_id' => Auth::id(),
                'skip_status' => '1',
                'server_type'=>3
            ],
        );
        return view('user.pages/domain-payment',$data);
    }


    public function user_modify_dns_server()
    {
        $data['title'] = 'User Modification Server Name';
        $user_id = getUserId();
        $get_user_dns_data_qry = DB::table('user_dns')->where('user_id',$user_id)->first();
        $data['get_user_dns_data']= $get_user_dns_data_qry;
        return view('user.pages/user-modify-dns-server',$data);
    }


    public function user_modification()
    {
        $data['title'] = 'User Modification';
        return view('user.pages/modification',$data);
    }

    public function user_update_profile()
    {
        $data['title'] = 'Profile Update';
        return view('user.pages/profile-update',$data);
    }
    public function user_contact_us()
    {
        $data['title'] = 'Contact Us';
        return view('user.pages/contact-us',$data);
    }

    public function user_remark()
    {
        $data['title'] = 'Remark Form';
        return view('user.pages/user-remark',$data);
    }

public function user_rmrk_sumbit(Request $request){



   $request->validate([
    'name' => 'required|string|max:50',
    'email' => 'required|email|max:50',
    'remark' => 'required|string|max:200',
], [
    'name.required' => 'Name is required.',
    'email.required' => 'Email is required.',
    'remark.required' => 'Remark is required'
]);

$sender_email = EmailSetting::first();
$misc_settings = DB::table('misc_settings')->first();
$fromEmail = $sender_email['from_address'];
$toemail=$misc_settings->email_address_one;

DB::table('feedback')->insert([
    'name' => $request->input('name'),
    'email' => $request->input('email'),
    'remark'=>$request->input('remark')
]);

$data=[];

$emailcc=[
    $misc_settings->email_address_two,
    $misc_settings->email_address_optional
];

$data['name']=$request->input('name');
$data['email']=$request->input('email');
$data['remark']=$request->input('remark');

Mail::send('front.email.feedback', $data, function ($message) use ($data, $fromEmail,$toemail,$emailcc) {
    $message->to($toemail)
        ->cc($emailcc)
        ->from($fromEmail) 
        ->subject('ERNET Feedback');
});

return redirect('user-remark')->with('success', 'Feedback submitted successfully!');


}

    public function signOut() {
        $storetoken=DB::table('users')->where('id',Auth::user()->id)->update(['active_session_token'=>null]);
        $this->logoutHistory(Auth::user()->id);
        Auth::logout();
        return Redirect('user-login');
    }

    private function logoutHistory($userid)
	{
		$res = LoginHistory::where('user_id', $userid)->where('logout', 0)->first();
		if($res) {
			if($res->logout == 0)
			{
				$pkid = $res->id;
				$datetime1 = $res->login_time;
				$datetime2 = date('Y-m-d H:i:s');
					
				$time1 = strtotime($datetime1);
				$time2 = strtotime($datetime2);
				
				$diff =  abs(strtotime($datetime1) - strtotime($datetime2));
					
				$difftext =	seconds2humanApi($diff);
					
				$durationCount = 0;
					
				$result = LoginHistory::where('user_id', $userid)->get();
				foreach($result as $resultdata) {
					$durationCount += $resultdata->duration;
				}
				
					if($durationCount == 0)
					{
						$updateq =	LoginHistory::where('id', $pkid)->update(
						[
							'logout_time' => $datetime2,
							'duration' => $diff,
							'duration_time' => $difftext,
							'total_duration' => $diff,
							'total_duration_time' => $difftext,
							'logout' => 1
						]);
					}
					else
					{
						$datetime1 = $res->login_time;
						$datetime2 = date('Y-m-d H:i:s');
						
						$time1 = strtotime($datetime1);
						$time2 = strtotime($datetime2);
						$diff =  abs(strtotime($datetime1) - strtotime($datetime2));
						$difftext =	seconds2humanApi($diff);
						$durationCountsum = $durationCount+$diff;
						$durationCountdifftext =	seconds2humanApi($durationCountsum);
						
						$updateq =	LoginHistory::where('id', $pkid)->update(
						[
							'logout_time' => $datetime2,
							'duration' => $diff,
							'duration_time' => $difftext,
							'total_duration' => $durationCountsum,
							'total_duration_time' => $durationCountdifftext,
							'logout' => 1
						]);
					}
			}
		}
	}

    public function renew_domain()
    {
        $user_id = Auth::id();
        $user=Auth::user();
        $userExpiryDate = Carbon::parse($user->domainExpiryDate);
        $maxdate = now()->addYears(10);

        $allowyears = $maxdate->diffInYears($userExpiryDate);
 
        $data['title'] = 'Renew Domain';
        $data['renew_prices'] = DB::table('domain_extension_prices')->where('domain_extension_id','=',Auth::user()->domainExtensionID)->where('year','<=',$allowyears)->orderBy('year','asc')->get();
        return view('user.pages.renew-domain',$data);
    }

    public function getExtensionPrices($price_id)
    {
        $data =  DB::table('domain_extension_prices')->where('id','=',$price_id)->first();
        if ($data != null){
            return['status'=> true, 'msg' => 'data fetched', 'data'=>$data];

        }else{
            return['status'=> true, 'data'=>$data];
        }

    }

    public function domainRenewal(Request $request)
    {
        try {
            $user_id = Auth::id();
            $request->validate([
                'year' => 'required',
                'server_price' => 'required',
                'server_price_tax' => 'required',
                'server_price_total' => 'required',
            ]);

            $updated_date = date('Y-m-d H:i:s');
            $user = User::find($user_id);
            $user->domainPeriod = $request->input('year');
            $user->domainPrice = $request->input('server_price_total');
            $user->domainExpiryDate = Carbon::now()->addYears($request->input('year'));
            $user->updated_at = $updated_date;
            $user->save();
            return ['status'=>true,  'msg'=>'DNS Name Server Saved Successfully'];
        } catch (Throwable $e) {
            return ['status'=>false, 'msg'=>$e->getMessage()];
        }
    }

    public function modify_ernet_dns_record()
    {
        $user_id = Auth::id();
        $data['title'] = 'Modify Ernet DNS Records';
        $data['records'] = DB::table('user_name_server_records')->where('user_id','=',$user_id)->get();
        return view('user.pages.modify-ernet-dns-records',$data);
    }

    public function save_ernet_dns_record(Request $request)
    {
        try {
            $user_id = Auth::id();
            $zone=Zone::where('user_id',$user_id)->first();
            $zone->update(['transfer_leave'=>1]);

            $data=$request->input('data');

            $name=$request->input('name');

            if($request->input('name')==null || $request->input('name')=='@' || $request->input('name')==''){
                $name=Auth::user()->domainName;
            }else if($name==Auth::user()->domainName){
                $name=$request->input('name');
            }else{
                $name=$request->input('name').'.'.Auth::user()->domainName;
            }

            if($request->input('id')==null){

                if($request->type=='A' || $request->type=='AAAA'){

                    $checkrecord=DB::table('user_name_server_records')->where('name',$name)->where('type',$request->type)->first();
                    if($checkrecord!=null){
                        return ['status'=>false, 'msg'=>'Same Record already exists'];
                    }

                }else{

                    $checkrecord=DB::table('user_name_server_records')->where('data',$data)->where('name',$name)->where('type',$request->type)->first();
                    if($checkrecord!=null){
                        return ['status'=>false, 'msg'=>'Same Record already exists'];
                    }

                }

            }

            $data = [
                'zone_id'=>$zone->id,
                "user_id" => $user_id,
                "type" => $request->input('type'),
                "name" => $name,
                "data" => $data,
                "ttl" => ($request->input('ttl'))?$request->input('ttl'):'3600',
                "priority" => $request->input('priority'),
                "weight" => $request->input('weight'),
                "port" => $request->input('port'),
                "service" => $request->input('service'),
                "protocol" => $request->input('protocol'),
            ];
            DB::table('user_name_server_records')
                ->updateOrInsert(
                    ['id' => $request->input('id')],
                    $data
                );

            $user = User::find($user_id);
            $user->zone_file = 1;
            $user->save();
            $zone=Zone::where('user_id',$user_id)->first();
            return ['status'=>true, 'msg'=>'Record has been updated Successfully'];
        } catch (Throwable $e) {
            return ['status'=>false, 'msg'=>$e->getMessage()];
        }
    }

    private function createzone(Zone $zone){
        $zone->increaseSerialNumber();
        $content = BINDFormatter::getZoneFileContent($zone);
        $path = self::ZONE_BASEDIR.DIRECTORY_SEPARATOR.$zone->domain;
        Storage::append($path, $content);

        try {        

          
            $destinationFileName = $zone->domain;

           

            $destinationFileName1 = $zone->domain;

            $destinationServer1 = '49.50.97.172';
            $destinationUsername1 = 'root';
            $destinationPassword1 = '54_n5dTe!V2';
            $destinationFolder1 = '/var/zones/primary';

            $sftp1 = new SFTP($destinationServer1,'2232');

            if (!$sftp1->login($destinationUsername1, $destinationPassword1)) {
                throw new \Exception('SFTP login failed');
            }

            if (!$sftp1->chdir($destinationFolder1)) {
                throw new \Exception('Failed to change directory on the destination server');
            }

            if ($sftp1->file_exists($destinationFileName1)) {
                if (!$sftp1->delete($destinationFileName1)) {
                    throw new \Exception('Failed to delete the existing file on the destination server');
                }
            }

            if (!$sftp1->put($destinationFileName1, $content)) {

            $sftp1->disconnect();

            $destinationServer = '49.50.97.169';
            $destinationUsername = 'root';
            $destinationPassword = 'y1BA8=W5@eK';
            $destinationFolder = '/var/zones/primary';

            $sftp = new SFTP($destinationServer,'2232');

            if (!$sftp->login($destinationUsername, $destinationPassword)) {
                throw new \Exception('SFTP login failed');
            }

            if (!$sftp->chdir($destinationFolder)) {
                throw new \Exception('Failed to change directory on the destination server');
            }

            if ($sftp->file_exists($destinationFileName)) {
                if (!$sftp->delete($destinationFileName)) {
                    throw new \Exception('Failed to delete the existing file on the destination server');
                }
            }

            if (!$sftp->put($destinationFileName, $content)) {
                throw new \Exception('Failed to transfer the file to the destination server');
            }

            $sftp->disconnect();

            }


                        $sftp1->disconnect();


        } catch (\Exception $e) {

        }
    }

    public function deleteRecord($id)
    {
        try {
            $user_id = Auth::id();
            DB::table('user_name_server_records')->where('id','=',$id)->delete();
            return ['status'=>true,  'msg'=>'Record has been Deleted Successfully'];
        } catch (Throwable $e) {
            return ['status'=>false, 'msg'=>$e->getMessage()];
        }
    }

    public function pushResourceRecord()
    {
        try {
            Artisan::call('record:push');
            return ['status'=>true, 'data'=>Artisan::output(), 'msg'=>'Record has been Pushed Successfully'];
        } catch (Throwable $e) {
            return ['status'=>false, 'msg'=>$e->getMessage()];
        }
    }
    public function schoolAffilationGet(Request $request)
    {
        $query = $request->query('query');
        $suggestions = DB::table('school_affilation')->where('aff_no', $query)->get();
        return response()->json($suggestions);
    }
    public function schoolAffilationSave(Request $request)
    {
        $user_id = Auth::id();
        $catid = DB::table('document_category')->where('title','Affiliation Letter')->first();

        DB::table('users')->where('id', $user_id)->update([
           'institute' => $request['school_name']
        ]);

        DB::table('user_contact_details')->where('user_id', $user_id)->update([
            'address' => $request['address']
        ]);

        $userDoc=DB::table('user_documents')->where('user_id',$user_id)->where('document_category_id', $catid->id)->first();
        if($userDoc){
            $path = public_path('user/docs');
            if(file_exists(public_path('user/docs/'.$userDoc->path))){
                unlink(public_path('user/docs/'.$userDoc->path));
            }
        }
        $status = DB::table('user_documents')
        ->updateOrInsert(
            ['user_id' => $user_id,'document_category_id' => $catid->id],
            [
                'user_id' => $user_id,
                'document_category_id' => $catid->id,
                'name' => $request['school_name'],
                'remarks' => $request['address'],
                'path' => $request['aff_no'],
                'upload_type'=>1, 
                'status' => 2,
            ]
        );
        return response()->json(['status' => true, 'msg' => 'Document has verified']);
    }
    public function Publish()
    {
        $user_id = Auth::id();
        $period=Auth::user()->domainPeriod;
        $VasPrices=DB::table('ernet_name_servers_prices')->orderBy('years', 'ASC')->get();
        $data['ernet_name_server'] = DB::table('ernet_name_servers')->where('status','=',1)->first();
        $data['ernet_name_server_prices'] = DB::table('ernet_name_servers_prices')->where('ernet_name_server_id','=',$data['ernet_name_server']->id) ->where(
                'years','<=',$period
            )->orderBy('years','asc')->get();
        $data['user_name_server'] = null;
        return view('front.publish',compact('VasPrices','data'));
    }

    public function ewaaspublish()
    {
        $user_id = Auth::id();
        $period=Auth::user()->domainPeriod;
        $VasPrices=DB::table('ernet_name_servers_prices')->orderBy('years', 'ASC')->get();
        $data['ernet_name_server'] = DB::table('ernet_name_servers')->where('status','=',1)->first();
        $data['ernet_name_server_prices'] = DB::table('ernet_name_servers_prices')->where('ernet_name_server_id','=',$data['ernet_name_server']->id) ->where(
                'years','<=',$period
            )->orderBy('years','asc')->get();
        $data['user_name_server'] = null;
        return view('front.ewaaspublish',compact('VasPrices','data'));
    }

    public function change_password()
    {
        $data['title'] = 'Change Password';
        return view('user.pages.change_password', $data);

    }

    public function verify_change_password(Request $request)
    {
        $params = $request->all();
        $messages = [
            'old_password.required' => 'Please enter old password.',
            'new_password.required' => 'Please enter new password.',
            'confirm_password.required' => 'Please enter confirm password.'
        ];
        $rules = ['old_password' =>'required','new_password' =>'required','confirm_password' =>'same:new_password|min:8'];
        $validator = validator()->make($params, $rules, $messages);
        if ($validator->fails())
        {
            return Redirect::back()->withErrors($validator->errors());
        }
        $user_id = Auth::id();

        $obj = DB::table('users')->where('id', $user_id)->first();
        

            if (Hash::check($request->old_password,$obj->password)) 
            {
                $password = Hash::make($request->new_password);
                $status = DB::table('users')->where('id', $obj->id)->update([
                    'password' => $password
                ]);
               return redirect('change_password')->with('success', 'Password changed successfully.');
            }
            else
            {
                return redirect('change_password')->with('error', 'Opps! You have entered invalid credentials.');
            }
        
        return redirect('change_password')->with('error', 'The current password is incorrect.');


    }
}
