<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Auth;
use Log;
use Illuminate\Support\Facades\Session;

class CheckIfAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
    */
    public function handle(Request $request, Closure $next)
    {

      $response = $next($request);
        $response->header('Cache-Control', 'no-store, no-cache, must-revalidate, max-age=0');
        $response->header('Pragma', 'no-cache');
        $response->header('Expires', 'Sat, 01 Jan 1990 00:00:00 GMT');

        if(!Auth::guard('admin')->check())
        {
          return redirect()->route('admin.login'); 
        } 
        $Session_key = Session::get('auth_token');
        $active_session_token = Auth::guard('admin')->user()->active_session_token;
        if($Session_key != $active_session_token)
        {
          Session::flash('message', 'Your session gets logged out!');
          Session::flash('alert-class', 'alert-danger');
          
          $role=Auth::guard('admin')->user()->role;

          Auth::guard('admin')->logout();

          if($role==1){
            return redirect()->route('admin.login'); 
          }else{
            return redirect()->route('bulk.login'); 
          }
          #return redirect()->route('admin.logout');
        }
        #Log::info($active_session_token);
        return $response;
    }
}
