<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;

class CheckUserAgent
{
    public function handle($request, Closure $next)
    {
        
        $guard = Auth::guard('admin'); 

        $storedUserAgent = session('user_agent');
        $currentUserAgent = $request->header('User-Agent');

        if ($storedUserAgent !== $currentUserAgent) {
            $guard->logout();

            Session::flash('message', 'Your session gets logged out!');
            Session::flash('alert-class', 'alert-danger');
            return redirect()->route('admin.login');
        }

        return $next($request);
    }
}
