<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Auth;
use Log;
use Illuminate\Support\Facades\Session;

class User
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        $response->header('Cache-Control', 'no-cache, no-store, max-age=0, must-revalidate');

        $response->header('Pragma', 'no-cache');

        $response->header('Expires', 'Fri, 01 Jan 1990 00:00:00 GMT');

        $Session_key = Session::get('auth_active_token')??'';
        
        $active_session_token = Auth::user()->active_session_token??'';
        #Log::info($active_session_token);
        if($Session_key != $active_session_token)
        {
          Session::flash('message', 'Your session gets logged out!');
          Session::flash('alert-class', 'alert-danger');
          Auth::logout();
          #Auth::guard('admin')->logout();
          return redirect()->route('user.login'); 
          #return redirect()->route('admin.logout');
        }

        return $response;
    }
}
