<?php

namespace JagdishJP\Billdesk\Messages;

use Illuminate\Support\Facades\Config;
use Illuminate\Support\Str;
use JagdishJP\Billdesk\Models\Transaction;

class Message
{
    public const TYPE_FIELD_1 = 'R';

    public const TYPE_FIELD_2 = 'F';

    public const NA_FIELD     = 'NA';

    /** Transaction Id For Each Payment */
    public $id;

    /** Transaction Id generated by BILLDESK on each transaction */
    public $transaction_id;

    /** Security Key provided by BILLDESK */
    public $securityId;

    /** Merchant ID provided by BILLDESK */
    public $merchantId;

    /** UAT Prefix provided by BILLDESK */
    public $uatPrefix;

    /** BILLDESK type field */
    public $typeField1;

    /** BILLDESK type field */
    public $typeField2;

    /** Na Field */
    public $naData1;

    /** Na Field */
    public $naData2;

    /** Na Field */
    public $naData3;

    /** Na Field */
    public $naData4;

    /** Na Field */
    public $naData5;

    /** Na Field */
    public $naData7;

    /** Na Field */
    public $naData8;

    /** Currency */
    public $currencyType;

    /** Total amount to be paid */
    public $amount;

    /** datetime of the transaction in YYYYMMDDHHmmSS format */
    public $timestamp;

    /** datetime of the transaction generate from BILLDESK in YYYYMMDDHH24MISS */
    public $transactionTimestamp;

    /** Reference Number used to reference the transaction */
    public $reference;

    /** Additional Info */
    public $additionalInfo1;

    /** Additional Info */
    public $additionalInfo2;

    /** Additional Info */
    public $additionalInfo3;

    /** Additional Info */
    public $additionalInfo4;

    /** Additional Info */
    public $additionalInfo5;

    /** Additional Info */
    public $additionalInfo6;

    /** Additional Info */
    public $additionalInfo7;

    /** Response Url */
    public $ResponseUrl;

    /** Transaction response status sent by BILLDESK */
    public $transactionStatus;

    /** Checksum key */
    public $checksumKey;

    /** Response checksum */
    public $checksum;

    /** BIlldesk Response */
    public $responseFormat;

    /** BIlldesk Response */
    public $response;

    /** Billdesk response keys */
    public $responseKeys;

    /** Billdesk Query response keys */
    public $queryResponseKeys;

    /** Billdesk response values */
    public $responseValues;

    public function __construct()
    {
        $this->id           = $this->generate_uuid();
        $this->typeField1   = self::TYPE_FIELD_1;
        $this->typeField2   = self::TYPE_FIELD_2;
        $this->merchantId   = Config::get('billdesk.merchant_id');
        $this->securityId   = Config::get('billdesk.security_id');
        $this->checksumKey  = Config::get('billdesk.checksum_key');
        $this->uatPrefix    = Config::get('billdesk.uat_prefix');
        $this->currencyType = Config::get('billdesk.currency');

        $this->naData1 = $this->naData2 = $this->naData3 = $this->naData4
                       = $this->naData5            = $this->naData7            = $this->naData8
                       = $this->additionalInfo1            = $this->additionalInfo2            = $this->additionalInfo3
                       = $this->additionalInfo4            = $this->additionalInfo5
                       = $this->additionalInfo6            = $this->additionalInfo7            = self::NA_FIELD;

        $this->ResponseUrl  = Config::get('billdesk.response_url');
        $this->responseKeys = explode('|', 'MerchantID|UniqueTxnID|TxnReferenceNo|BankReferenceNo|TxnAmount|BankID|BIN|TxnType|'
            . 'CurrencyName|ItemCode|SecurityType|SecurityID|SecurityPassword|TxnDate|AuthStatus|SettlementType|AdditionalInfo1|'
            . 'AdditionalInfo2|AdditionalInfo3|AdditionalInfo4|AdditionalInfo5|AdditionalInfo6|AdditionalInfo7|ErrorStatus|'
            . 'ErrorDescription|CheckSum');

        $this->queryResponseKeys = explode('|', 'RequestType|MerchantID|UniqueTxnID|TxnReferenceNo|BankReferenceNo|TxnAmount|BankID|'
            . 'BankMerchantID|TxnType|CurrencyName|ItemCode|SecurityType|SecurityID|SecurityPassword|TxnDate|AuthStatus|SettlementType|'
            . 'AdditionalInfo1|AdditionalInfo2|AdditionalInfo3|AdditionalInfo4|AdditionalInfo5|AdditionalInfo6|AdditionalInfo7|ErrorStatus|'
            . 'ErrorDescription|Filler1|RefundStatus|TotalRefundAmount|LastRefundDate|LastRefundRefNo|QueryStatus|CheckSum');
    }

    public function generate_uuid()
    {
        do {
            $uuid = Str::uuid();
        } while (Transaction::where('unique_id', $uuid)->first());

        return $uuid;
    }
}
